/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import java.time.Duration;

public final class LeaderElectionConfigurationBuilder {
    private String leaseName;
    private String leaseNamespace;
    private String identity;
    private Duration leaseDuration = LeaderElectionConfiguration.LEASE_DURATION_DEFAULT_VALUE;
    private Duration renewDeadline = LeaderElectionConfiguration.RENEW_DEADLINE_DEFAULT_VALUE;
    private Duration retryPeriod = LeaderElectionConfiguration.RETRY_PERIOD_DEFAULT_VALUE;
    private LeaderCallbacks leaderCallbacks;

    private LeaderElectionConfigurationBuilder(String leaseName) {
        this.leaseName = leaseName;
    }

    public static LeaderElectionConfigurationBuilder aLeaderElectionConfiguration(String leaseName) {
        return new LeaderElectionConfigurationBuilder(leaseName);
    }

    public LeaderElectionConfigurationBuilder withLeaseNamespace(String leaseNamespace) {
        this.leaseNamespace = leaseNamespace;
        return this;
    }

    public LeaderElectionConfigurationBuilder withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public LeaderElectionConfigurationBuilder withLeaseDuration(Duration leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaderElectionConfigurationBuilder withRenewDeadline(Duration renewDeadline) {
        this.renewDeadline = renewDeadline;
        return this;
    }

    public LeaderElectionConfigurationBuilder withRetryPeriod(Duration retryPeriod) {
        this.retryPeriod = retryPeriod;
        return this;
    }

    public LeaderElectionConfigurationBuilder withLeaderCallbacks(LeaderCallbacks leaderCallbacks) {
        this.leaderCallbacks = leaderCallbacks;
        return this;
    }

    public LeaderElectionConfiguration build() {
        return new LeaderElectionConfiguration(this.leaseName, this.leaseNamespace, this.leaseDuration, this.renewDeadline, this.retryPeriod, this.identity, this.leaderCallbacks);
    }
}

