/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.workflow;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.AbstractWorkflowExecutor;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DependentResourceNode;

abstract class NodeExecutor<R, P extends HasMetadata>
implements Runnable {
    private final DependentResourceNode<R, P> dependentResourceNode;
    private final AbstractWorkflowExecutor<P> workflowExecutor;

    protected NodeExecutor(DependentResourceNode<R, P> dependentResourceNode, AbstractWorkflowExecutor<P> workflowExecutor) {
        this.dependentResourceNode = dependentResourceNode;
        this.workflowExecutor = workflowExecutor;
    }

    @Override
    public void run() {
        try {
            DependentResource<R, P> dependentResource = this.dependentResourceNode.getDependentResource();
            this.doRun(this.dependentResourceNode, dependentResource);
        }
        catch (RuntimeException e) {
            this.workflowExecutor.handleExceptionInExecutor(this.dependentResourceNode, e);
        }
        finally {
            this.workflowExecutor.handleNodeExecutionFinish(this.dependentResourceNode);
        }
    }

    protected abstract void doRun(DependentResourceNode<R, P> var1, DependentResource<R, P> var2);
}

