/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.reconciler;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.Cache;
import io.javaoperatorsdk.operator.processing.event.source.ResourceEventSource;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class ResourceIDMatcherDiscriminator<R extends HasMetadata, P extends HasMetadata>
implements ResourceDiscriminator<R, P> {
    private final String eventSourceName;
    private final Function<P, ResourceID> mapper;

    public ResourceIDMatcherDiscriminator(Function<P, ResourceID> mapper) {
        this(null, mapper);
    }

    public ResourceIDMatcherDiscriminator(String eventSourceName, Function<P, ResourceID> mapper) {
        this.eventSourceName = eventSourceName;
        this.mapper = mapper;
    }

    @Override
    public Optional<R> distinguish(Class<R> resource, P primary, Context<P> context) {
        ResourceID resourceID = this.mapper.apply(primary);
        if (this.eventSourceName != null) {
            return ((Cache)((Object)context.eventSourceRetriever().getResourceEventSourceFor(resource, this.eventSourceName))).get(resourceID);
        }
        List<ResourceEventSource<R, P>> eventSources = context.eventSourceRetriever().getResourceEventSourcesFor(resource);
        if (eventSources.size() == 1) {
            return ((Cache)((Object)eventSources.get(0))).get(resourceID);
        }
        return context.getSecondaryResourcesAsStream(resource).filter(resourceID::isSameResource).findFirst();
    }
}

