/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config.dependent;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.config.dependent.ConfigurationConverter;
import io.javaoperatorsdk.operator.api.config.dependent.Configured;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceConfigurationProvider;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.api.reconciler.dependent.managed.DependentResourceConfigurator;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class DependentResourceConfigurationResolver {
    private static final Map<Class<? extends DependentResource>, ConverterAnnotationPair> converters = new HashMap<Class<? extends DependentResource>, ConverterAnnotationPair>();
    private static final Map<Class<? extends ConfigurationConverter>, ConfigurationConverter> knownConverters = new HashMap<Class<? extends ConfigurationConverter>, ConfigurationConverter>();

    private DependentResourceConfigurationResolver() {
    }

    public static <C extends ControllerConfiguration<? extends HasMetadata>> void configure(DependentResource dependentResource, DependentResourceSpec spec, C parentConfiguration) {
        if (dependentResource instanceof DependentResourceConfigurator) {
            DependentResourceConfigurator configurator = (DependentResourceConfigurator)((Object)dependentResource);
            Object config = DependentResourceConfigurationResolver.configurationFor(spec, parentConfiguration);
            configurator.configureWith(config);
        }
    }

    public static <C extends ControllerConfiguration<? extends HasMetadata>> Object configurationFor(DependentResourceSpec spec, C parentConfiguration) {
        DependentResourceConfigurationProvider provider;
        Object configuration;
        if (parentConfiguration instanceof DependentResourceConfigurationProvider && (configuration = (provider = (DependentResourceConfigurationProvider)((Object)parentConfiguration)).getConfigurationFor(spec)) != null) {
            return configuration;
        }
        return DependentResourceConfigurationResolver.extractConfigurationFromConfigured(spec.getDependentResourceClass(), parentConfiguration);
    }

    public static <C extends ControllerConfiguration<? extends HasMetadata>> Object extractConfigurationFromConfigured(Class<? extends DependentResource> dependentResourceClass, C parentConfiguration) {
        ConverterAnnotationPair converterAnnotationPair = converters.get(dependentResourceClass);
        if (converterAnnotationPair == null) {
            ConfiguredClassPair configuredClassPair = DependentResourceConfigurationResolver.getConfigured(dependentResourceClass);
            if (configuredClassPair == null) {
                return null;
            }
            converterAnnotationPair = converters.get(configuredClassPair.annotatedClass);
            if (converterAnnotationPair == null) {
                Configured configured = configuredClassPair.configured;
                converterAnnotationPair = DependentResourceConfigurationResolver.getOrCreateConverter(dependentResourceClass, parentConfiguration, configured.converter(), configured.by());
            } else {
                converters.put(dependentResourceClass, converterAnnotationPair);
            }
        }
        Annotation configAnnotation = dependentResourceClass.getAnnotation(converterAnnotationPair.annotationClass);
        ConfigurationConverter converter = converterAnnotationPair.converter;
        return converter.configFrom(configAnnotation, parentConfiguration, dependentResourceClass);
    }

    private static ConfiguredClassPair getConfigured(Class<? extends DependentResource> dependentResourceClass) {
        Class<? extends DependentResource> currentClass = dependentResourceClass;
        ConfiguredClassPair result = null;
        while (DependentResource.class.isAssignableFrom(currentClass)) {
            Configured configured = currentClass.getAnnotation(Configured.class);
            if (configured != null) {
                result = new ConfiguredClassPair(configured, currentClass);
                break;
            }
            currentClass = currentClass.getSuperclass();
        }
        return result;
    }

    private static <C extends ControllerConfiguration<? extends HasMetadata>> ConverterAnnotationPair getOrCreateConverter(Class<? extends DependentResource> dependentResourceClass, C parentConfiguration, Class<? extends ConfigurationConverter> converterClass, Class<? extends Annotation> annotationClass) {
        ConverterAnnotationPair converterPair = converters.get(dependentResourceClass);
        if (converterPair == null) {
            ConfigurationConverter converter = knownConverters.get(converterClass);
            if (converter == null) {
                converter = Utils.instantiate(converterClass, ConfigurationConverter.class, Utils.contextFor(parentConfiguration, dependentResourceClass, Configured.class));
                knownConverters.put(converterClass, converter);
            }
            converterPair = new ConverterAnnotationPair(converter, annotationClass);
            converters.put(dependentResourceClass, converterPair);
        }
        return converterPair;
    }

    static ConfigurationConverter getConverter(Class<? extends DependentResource> dependentResourceClass) {
        ConverterAnnotationPair converterAnnotationPair = converters.get(dependentResourceClass);
        return converterAnnotationPair != null ? converterAnnotationPair.converter : null;
    }

    public static void registerConverter(Class<? extends DependentResource> dependentResourceClass, ConfigurationConverter converter) {
        ConfiguredClassPair configured = DependentResourceConfigurationResolver.getConfigured(dependentResourceClass);
        if (configured == null) {
            throw new IllegalArgumentException("There is no @" + Configured.class.getSimpleName() + " annotation on " + dependentResourceClass.getName() + " or its superclasses and thus doesn't need to be associated with a converter");
        }
        ConverterAnnotationPair toRegister = new ConverterAnnotationPair(converter, configured.configured.by());
        Class<?> converterClass = converter.getClass();
        converters.put(dependentResourceClass, toRegister);
        if (!dependentResourceClass.equals(configured.annotatedClass)) {
            converters.put(configured.annotatedClass, toRegister);
        }
        knownConverters.put(converterClass, converter);
    }

    public static void clear() {
        converters.clear();
        knownConverters.clear();
    }

    private static class ConverterAnnotationPair {
        private final ConfigurationConverter converter;
        private final Class<? extends Annotation> annotationClass;

        private ConverterAnnotationPair(ConfigurationConverter converter, Class<? extends Annotation> annotationClass) {
            this.converter = converter;
            this.annotationClass = annotationClass;
        }

        public String toString() {
            return this.converter.toString() + " -> " + this.annotationClass.getName();
        }
    }

    private static class ConfiguredClassPair {
        private final Configured configured;
        private final Class<? extends DependentResource> annotatedClass;

        private ConfiguredClassPair(Configured configured, Class<? extends DependentResource> annotatedClass) {
            this.configured = configured;
            this.annotatedClass = annotatedClass;
        }

        public String toString() {
            return this.annotatedClass.getName() + " -> " + this.configured;
        }
    }
}

