/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.config.InformerStoppedHandler;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.Constants;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RetryConfigurationResolver;
import io.quarkiverse.operatorsdk.runtime.RunTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RunTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.Version;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class ConfigurationServiceRecorder {
    static final Logger log = Logger.getLogger((String)ConfigurationServiceRecorder.class.getName());

    public Supplier<QuarkusConfigurationService> configurationServiceSupplier(Version version, Map<String, QuarkusControllerConfiguration> configurations, CRDGenerationInfo crdInfo, RunTimeOperatorConfiguration runTimeConfiguration, BuildTimeOperatorConfiguration buildTimeConfiguration) {
        Integer maxThreads = runTimeConfiguration.concurrentReconciliationThreads.orElse(200);
        Integer timeout = runTimeConfiguration.terminationTimeoutSeconds.orElse(10);
        Integer workflowThreads = runTimeConfiguration.concurrentWorkflowThreads.orElse(200);
        Duration cacheSyncTimeout = runTimeConfiguration.cacheSyncTimeout;
        configurations.forEach((name, c) -> {
            Retry retry;
            RunTimeControllerConfiguration extConfig = runTimeConfiguration.controllers.get(name);
            if (extConfig != null) {
                extConfig.finalizer.ifPresent(c::setFinalizer);
                extConfig.selector.ifPresent(c::setLabelSelector);
                c.setRetryConfiguration(RetryConfigurationResolver.resolve(extConfig.retry));
                ConfigurationServiceRecorder.setNamespacesFromRuntime(c, extConfig.namespaces);
            }
            if ((retry = c.getRetry()) == null) {
                c.setRetryConfiguration(null);
            }
            if (!c.isWereNamespacesSet()) {
                ConfigurationServiceRecorder.setNamespacesFromRuntime(c, runTimeConfiguration.namespaces);
            }
        });
        return () -> {
            ArcContainer container = Arc.container();
            LeaderElectionConfiguration leaderElectionConfiguration = null;
            List profiles = ConfigUtils.getProfiles();
            if (profiles.stream().anyMatch(buildTimeConfiguration.activateLeaderElectionForProfiles::contains)) {
                leaderElectionConfiguration = (LeaderElectionConfiguration)container.instance(LeaderElectionConfiguration.class, new Annotation[0]).get();
            } else {
                log.info((Object)("Leader election deactivated because it is only activated for " + buildTimeConfiguration.activateLeaderElectionForProfiles + " profiles. Currently active profiles: " + profiles));
            }
            return new QuarkusConfigurationService(version, configurations.values(), (KubernetesClient)container.instance(KubernetesClient.class, new Annotation[0]).get(), crdInfo, maxThreads, workflowThreads, timeout, cacheSyncTimeout, (Metrics)container.instance(Metrics.class, new Annotation[0]).get(), buildTimeConfiguration.startOperator, leaderElectionConfiguration, (InformerStoppedHandler)container.instance(InformerStoppedHandler.class, new Annotation[0]).orElse(null), buildTimeConfiguration.closeClientOnStop, buildTimeConfiguration.stopOnInformerErrorDuringStartup, buildTimeConfiguration.enableSSA);
        };
    }

    private static void setNamespacesFromRuntime(QuarkusControllerConfiguration controllerConfig, Optional<List<String>> runtimeNamespaces) {
        if (runtimeNamespaces.isPresent()) {
            HashSet<String> namespaces = new HashSet<String>((Collection)runtimeNamespaces.get());
            if (!Constants.QOSDK_USE_BUILDTIME_NAMESPACES_SET.equals(namespaces)) {
                controllerConfig.setNamespaces(namespaces);
            }
        } else {
            controllerConfig.setNamespaces(io.javaoperatorsdk.operator.api.reconciler.Constants.DEFAULT_NAMESPACES_SET);
        }
    }
}

