/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event;

import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.ResourceState;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

class ResourceStateManager {
    private final Map<ResourceID, ResourceState> states = new ConcurrentHashMap<ResourceID, ResourceState>(100);

    ResourceStateManager() {
    }

    public ResourceState getOrCreate(ResourceID resourceID) {
        return this.states.computeIfAbsent(resourceID, ResourceState::new);
    }

    public ResourceState remove(ResourceID resourceID) {
        return this.states.remove(resourceID);
    }

    public boolean contains(ResourceID resourceID) {
        return this.states.containsKey(resourceID);
    }

    public List<ResourceState> resourcesWithEventPresent() {
        return this.states.values().stream().filter(state -> !state.noEventPresent()).collect(Collectors.toList());
    }
}

