/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.vertx.http.runtime.security.ImmutablePathMatcher;
import io.quarkus.vertx.http.runtime.security.ImmutableSubstringMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class SubstringMap<V> {
    private volatile Object[] table = new Object[16];
    private int size;

    @Deprecated
    public ImmutableSubstringMap.SubstringMatch<V> get(String key, int length) {
        return this.get(key, length, false);
    }

    @Deprecated
    public ImmutableSubstringMap.SubstringMatch<V> get(String key) {
        return this.get(key, key.length(), false);
    }

    private ImmutableSubstringMap.SubstringMatch<V> get(String key, int length, boolean exact) {
        int pos;
        if (key.length() < length) {
            throw new IllegalArgumentException();
        }
        Object[] table = this.table;
        int hash = ImmutableSubstringMap.hash(key, length);
        int start = pos = ImmutableSubstringMap.tablePos(table, hash);
        while (table[pos] != null) {
            if (exact ? table[pos].equals(key) : ImmutableSubstringMap.doEquals((String)table[pos], key, length)) {
                return (ImmutableSubstringMap.SubstringMatch)table[pos + 1];
            }
            if ((pos += 2) >= table.length) {
                pos = 0;
            }
            if (pos != start) continue;
            return null;
        }
        return null;
    }

    @Deprecated
    public synchronized void put(String key, V value) {
        this.put(key, value, null);
    }

    void put(String key, V value, ImmutablePathMatcher<ImmutableSubstringMap.SubstringMatch<V>> subPathMatcher) {
        Object[] newTable;
        if (key == null) {
            throw new NullPointerException();
        }
        if ((double)this.table.length / (double)this.size < 4.0 && this.table.length != Integer.MAX_VALUE) {
            newTable = new Object[this.table.length << 1];
            for (int i = 0; i < this.table.length; i += 2) {
                if (this.table[i] == null) continue;
                this.doPut(newTable, (String)this.table[i], this.table[i + 1]);
            }
        } else {
            newTable = new Object[this.table.length];
            System.arraycopy(this.table, 0, newTable, 0, this.table.length);
        }
        this.doPut(newTable, key, new ImmutableSubstringMap.SubstringMatch<V>(key, value, subPathMatcher));
        this.table = newTable;
        ++this.size;
    }

    @Deprecated
    public synchronized V remove(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object value = null;
        Object[] newTable = new Object[this.table.length];
        for (int i = 0; i < this.table.length; i += 2) {
            if (this.table[i] != null && !this.table[i].equals(key)) {
                this.doPut(newTable, (String)this.table[i], this.table[i + 1]);
                continue;
            }
            if (this.table[i] == null) continue;
            value = this.table[i + 1];
            --this.size;
        }
        this.table = newTable;
        if (value == null) {
            return null;
        }
        return ((ImmutableSubstringMap.SubstringMatch)value).getValue();
    }

    private void doPut(Object[] newTable, String key, Object value) {
        int hash = ImmutableSubstringMap.hash(key, key.length());
        int pos = ImmutableSubstringMap.tablePos(newTable, hash);
        while (newTable[pos] != null && !newTable[pos].equals(key)) {
            if ((pos += 2) < newTable.length) continue;
            pos = 0;
        }
        newTable[pos] = key;
        newTable[pos + 1] = value;
    }

    @Deprecated
    public Map<String, V> toMap() {
        HashMap map = new HashMap();
        Object[] t = this.table;
        for (int i = 0; i < t.length; i += 2) {
            if (t[i] == null) continue;
            map.put((String)t[i], ((ImmutableSubstringMap.SubstringMatch)t[i + 1]).getValue());
        }
        return map;
    }

    @Deprecated
    public synchronized void clear() {
        this.size = 0;
        this.table = new Object[16];
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                int i;
                final Object[] tMap = SubstringMap.this.table;
                for (i = 0; i < SubstringMap.this.table.length && tMap[i] == null; i += 2) {
                }
                final int startPos = i;
                return new Iterator<String>(){
                    private Object[] map;
                    private int pos;
                    {
                        this.map = tMap;
                        this.pos = startPos;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pos < SubstringMap.this.table.length;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        String ret = (String)this.map[this.pos];
                        this.pos += 2;
                        while (this.pos < SubstringMap.this.table.length && tMap[this.pos] == null) {
                            this.pos += 2;
                        }
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    ImmutableSubstringMap<V> asImmutableMap() {
        return new ImmutableSubstringMap(this.table);
    }
}

