/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;

public class DevUIBuildTimeStaticHandler
implements Handler<RoutingContext> {
    private Map<String, String> urlAndPath;
    private String basePath;
    private static final int STATUS = 200;
    private static final String OK = "OK";
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String CONTENT_TYPE = "Content-Type";

    public DevUIBuildTimeStaticHandler() {
    }

    public DevUIBuildTimeStaticHandler(String basePath, Map<String, String> urlAndPath) {
        this.basePath = basePath;
        this.urlAndPath = urlAndPath;
    }

    public Map<String, String> getUrlAndPath() {
        return this.urlAndPath;
    }

    public void setUrlAndPath(Map<String, String> urlAndPath) {
        this.urlAndPath = urlAndPath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void handle(RoutingContext event) {
        String normalizedPath = event.normalizedPath();
        if (normalizedPath.contains(SLASH)) {
            int si = normalizedPath.lastIndexOf(SLASH) + 1;
            String path = normalizedPath.substring(0, si);
            String fileName = normalizedPath.substring(si);
            if (path.startsWith(this.basePath) && this.urlAndPath.containsKey(fileName)) {
                String pathOnDisk = this.urlAndPath.get(fileName);
                try {
                    byte[] content = Files.readAllBytes(Path.of(pathOnDisk, new String[0]));
                    event.response().setStatusCode(200).setStatusMessage(OK).putHeader(CONTENT_TYPE, this.getMimeType(fileName)).end(Buffer.buffer((byte[])content));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    event.next();
                }
            } else {
                event.next();
            }
        } else {
            event.next();
        }
    }

    private String getMimeType(String fileName) {
        int dotIndex;
        String ext;
        if (fileName.contains(DOT) && !(ext = fileName.substring(dotIndex = fileName.lastIndexOf(DOT) + 1)).isEmpty()) {
            if (ext.equalsIgnoreCase("html") || ext.equalsIgnoreCase("htm")) {
                return "text/html";
            }
            if (ext.equalsIgnoreCase("js")) {
                return "text/javascript";
            }
            if (ext.equalsIgnoreCase("css")) {
                return "text/css";
            }
            if (ext.equalsIgnoreCase("json")) {
                return "application/json";
            }
        }
        return "text/plain";
    }

    public static interface FileExtension {
        public static final String HTML = "html";
        public static final String HTM = "htm";
        public static final String JS = "js";
        public static final String JSON = "json";
        public static final String CSS = "css";
    }

    public static interface MimeType {
        public static final String HTML = "text/html";
        public static final String JS = "text/javascript";
        public static final String JSON = "application/json";
        public static final String CSS = "text/css";
        public static final String PLAIN = "text/plain";
    }
}

