/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.FragmentSectionHelper;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class IncludeSectionHelper
implements SectionHelper {
    static final String DEFAULT_NAME = "$default$";
    private static final String TEMPLATE = "template";
    private static final Map<String, Object> FRAGMENT_PARAMS = Map.of("qute$fragment", true);
    protected final Supplier<Template> template;
    protected final Map<String, SectionBlock> extendingBlocks;
    protected final Map<String, Expression> parameters;
    protected final boolean isIsolated;

    public IncludeSectionHelper(Supplier<Template> templateSupplier, Map<String, SectionBlock> extendingBlocks, Map<String, Expression> parameters, boolean isIsolated) {
        this.template = templateSupplier;
        this.extendingBlocks = extendingBlocks;
        this.parameters = parameters;
        this.isIsolated = isIsolated;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        if (this.parameters.isEmpty() && this.optimizeIfNoParams()) {
            Template t = this.template.get();
            SectionNode root = ((TemplateImpl)t).root;
            ResolutionContext resolutionContext = this.isIsolated ? context.newResolutionContext(null, this.extendingBlocks) : (this.extendingBlocks.isEmpty() ? context.resolutionContext() : context.resolutionContext().createChild(null, this.extendingBlocks));
            return root.resolve(resolutionContext, t.isFragment() ? FRAGMENT_PARAMS : null);
        }
        CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
        context.evaluate(this.parameters).whenComplete((evaluatedParams, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                this.addAdditionalEvaluatedParams(context, (Map<String, Object>)evaluatedParams);
                try {
                    Mapper data = Mapper.wrap(evaluatedParams);
                    ResolutionContext resolutionContext = this.isIsolated ? context.newResolutionContext(data, this.extendingBlocks) : context.resolutionContext().createChild(data, this.extendingBlocks);
                    Template t = this.template.get();
                    SectionNode root = ((TemplateImpl)t).root;
                    root.resolve(resolutionContext, t.isFragment() ? FRAGMENT_PARAMS : null).whenComplete((resultNode, t2) -> {
                        if (t2 != null) {
                            result.completeExceptionally((Throwable)t2);
                        } else {
                            result.complete((ResultNode)resultNode);
                        }
                    });
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    protected boolean optimizeIfNoParams() {
        return true;
    }

    protected void addAdditionalEvaluatedParams(SectionHelper.SectionResolutionContext context, Map<String, Object> evaluatedParams) {
    }

    static enum Code implements ErrorCode
    {
        MULTIPLE_INSERTS_OF_NAME,
        TEMPLATE_NOT_FOUND,
        FRAGMENT_NOT_FOUND,
        INVALID_FRAGMENT_ID;


        @Override
        public String getName() {
            return "INCLUDE_" + this.name();
        }
    }

    static abstract class AbstractIncludeFactory<T extends SectionHelper>
    implements SectionHelperFactory<T> {
        static final String ISOLATED = "_isolated";
        static final String UNISOLATED = "_unisolated";
        static final String IGNORE_FRAGMENTS = "_ignoreFragments";

        AbstractIncludeFactory() {
        }

        @Override
        public boolean treatUnknownSectionsAsBlocks() {
            return true;
        }

        String isolatedDefaultValue() {
            return Boolean.FALSE.toString();
        }

        void addDefaultParams(SectionHelperFactory.ParametersInfo.Builder builder) {
            builder.addParameter(Parameter.builder(ISOLATED).defaultValue(this.isolatedDefaultValue()).optional().valuePredicate(ISOLATED::equals).build()).addParameter(Parameter.builder(IGNORE_FRAGMENTS).defaultValue(Boolean.FALSE.toString()).optional().valuePredicate(IGNORE_FRAGMENTS::equals).build()).build();
        }

        @Override
        public Scope initializeBlock(Scope outerScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                for (Map.Entry<String, String> entry : block.getParameters().entrySet()) {
                    String value;
                    String key = entry.getKey();
                    if (this.ignoreParameterInit(key, value = entry.getValue())) continue;
                    if (this.useDefaultedKey(key, value)) {
                        key = value;
                    }
                    block.addExpression(key, value);
                }
                return outerScope;
            }
            return outerScope;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T initialize(SectionHelperFactory.SectionInitContext context) {
            void var7_12;
            String string;
            String string2;
            Map<String, Expression> params;
            Map<String, SectionBlock> extendingBlocks;
            boolean isEmpty = context.getBlocks().size() == 1 && context.getBlocks().get(0).isEmpty();
            Boolean isolatedValue = null;
            boolean ignoreFragments = false;
            if (isEmpty) {
                extendingBlocks = Collections.emptyMap();
            } else {
                extendingBlocks = new HashMap();
                for (SectionBlock sectionBlock : context.getBlocks()) {
                    String string3 = sectionBlock.id.equals("$main") ? IncludeSectionHelper.DEFAULT_NAME : sectionBlock.label;
                    if (extendingBlocks.put(string3, sectionBlock) == null) continue;
                    throw sectionBlock.error("multiple blocks define the content for the \\{#insert\\} section of name [{name}]").code(Code.MULTIPLE_INSERTS_OF_NAME).origin(context.getOrigin()).argument("name", string3).build();
                }
            }
            if (context.getParameters().size() == 1) {
                params = Collections.emptyMap();
            } else {
                params = new HashMap();
                for (Map.Entry<String, String> entry : context.getParameters().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (value.equals(ISOLATED)) {
                        isolatedValue = true;
                        continue;
                    }
                    if (value.equals(UNISOLATED)) {
                        isolatedValue = false;
                        continue;
                    }
                    if (value.equals(IGNORE_FRAGMENTS)) {
                        ignoreFragments = true;
                        continue;
                    }
                    this.handleParamInit(key, value, context, params);
                }
            }
            String string4 = this.getTemplateId(context);
            if (!ignoreFragments) {
                ignoreFragments = Boolean.parseBoolean(context.getParameterOrDefault(IGNORE_FRAGMENTS, "false"));
            }
            String string5 = string2 = ignoreFragments ? null : this.getFragmentId(string4, context);
            final Supplier<Template> currentTemplate = string2 != null ? ((string = string4.substring(0, string4.lastIndexOf(36))).isEmpty() ? context.getCurrentTemplate() : null) : null;
            void finalTemplateId = var7_12;
            final Engine engine = context.getEngine();
            Supplier<Template> template = new Supplier<Template>((String)finalTemplateId, context, string2){
                final /* synthetic */ String val$finalTemplateId;
                final /* synthetic */ SectionHelperFactory.SectionInitContext val$context;
                final /* synthetic */ String val$fragmentId;
                {
                    this.val$finalTemplateId = string;
                    this.val$context = sectionInitContext;
                    this.val$fragmentId = string2;
                }

                @Override
                public Template get() {
                    Template template = currentTemplate != null ? (Template)currentTemplate.get() : engine.getTemplate(this.val$finalTemplateId);
                    if (template == null) {
                        throw engine.error("included template [{templateId}] not found").code(Code.TEMPLATE_NOT_FOUND).argument("templateId", this.val$finalTemplateId).origin(this.val$context.getOrigin()).build();
                    }
                    if (this.val$fragmentId != null) {
                        Template.Fragment fragment = template.getFragment(this.val$fragmentId);
                        if (fragment == null) {
                            throw engine.error("fragment [{fragmentId}] not found in the included template [{templateId}]").code(Code.FRAGMENT_NOT_FOUND).argument("templateId", this.val$finalTemplateId).argument("fragmentId", this.val$fragmentId).origin(this.val$context.getOrigin()).build();
                        }
                        template = fragment;
                    }
                    return template;
                }
            };
            return this.newHelper(template, params, extendingBlocks, isolatedValue, context);
        }

        protected abstract String getTemplateId(SectionHelperFactory.SectionInitContext var1);

        protected String getFragmentId(String templateId, SectionHelperFactory.SectionInitContext context) {
            int idx = templateId.lastIndexOf(36);
            if (idx != -1) {
                String fragmentId = templateId.substring(idx + 1, templateId.length());
                if (FragmentSectionHelper.Factory.FRAGMENT_PATTERN.matcher(fragmentId).matches()) {
                    return fragmentId;
                }
                throw context.getEngine().error("invalid fragment identifier [{fragmentId}]").code(Code.INVALID_FRAGMENT_ID).argument("fragmentId", fragmentId).origin(context.getOrigin()).build();
            }
            return null;
        }

        protected void handleParamInit(String key, String value, SectionHelperFactory.SectionInitContext context, Map<String, Expression> params) {
            if (this.ignoreParameterInit(key, value)) {
                return;
            }
            if (this.useDefaultedKey(key, value)) {
                key = value;
            }
            params.put(key, context.getExpression(key));
        }

        protected boolean useDefaultedKey(String key, String value) {
            return LiteralSupport.INTEGER_LITERAL_PATTERN.matcher(key).matches() && this.isSinglePart(value);
        }

        protected boolean isSinglePart(String value) {
            return Expressions.splitParts(value).size() == 1;
        }

        protected boolean ignoreParameterInit(String key, String value) {
            return key.equals(IGNORE_FRAGMENTS);
        }

        protected abstract T newHelper(Supplier<Template> var1, Map<String, Expression> var2, Map<String, SectionBlock> var3, Boolean var4, SectionHelperFactory.SectionInitContext var5);
    }

    public static class Factory
    extends AbstractIncludeFactory<IncludeSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("include");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            SectionHelperFactory.ParametersInfo.Builder builder = SectionHelperFactory.ParametersInfo.builder().addParameter(IncludeSectionHelper.TEMPLATE);
            this.addDefaultParams(builder);
            return builder.build();
        }

        @Override
        public SectionHelperFactory.MissingEndTagStrategy missingEndTagStrategy() {
            return SectionHelperFactory.MissingEndTagStrategy.BIND_TO_PARENT;
        }

        @Override
        protected boolean ignoreParameterInit(String key, String value) {
            return key.equals(IncludeSectionHelper.TEMPLATE) || key.equals("_isolated") || value.equals("_isolated") || value.equals("_unisolated") || key.equals("_ignoreFragments") || value.equals("_ignoreFragments");
        }

        @Override
        protected String getTemplateId(SectionHelperFactory.SectionInitContext context) {
            String templateParam = context.getParameter(IncludeSectionHelper.TEMPLATE);
            if (LiteralSupport.isStringLiteralSeparator(templateParam.charAt(0))) {
                templateParam = templateParam.substring(1, templateParam.length() - 1);
            }
            return templateParam;
        }

        @Override
        protected IncludeSectionHelper newHelper(Supplier<Template> template, Map<String, Expression> params, Map<String, SectionBlock> extendingBlocks, Boolean isolatedValue, SectionHelperFactory.SectionInitContext context) {
            return new IncludeSectionHelper(template, extendingBlocks, params, isolatedValue != null ? isolatedValue : Boolean.parseBoolean(context.getParameterOrDefault("_isolated", Boolean.FALSE.toString())));
        }
    }
}

