/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.EventHandler;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.PrimaryToSecondaryMapper;
import io.javaoperatorsdk.operator.processing.event.source.informer.DefaultPrimaryToSecondaryIndex;
import io.javaoperatorsdk.operator.processing.event.source.informer.ManagedInformerEventSource;
import io.javaoperatorsdk.operator.processing.event.source.informer.NOOPPrimaryToSecondaryIndex;
import io.javaoperatorsdk.operator.processing.event.source.informer.PrimaryToSecondaryIndex;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformerEventSource<R extends HasMetadata, P extends HasMetadata>
extends ManagedInformerEventSource<R, P, InformerConfiguration<R>>
implements ResourceEventHandler<R> {
    public static String PREVIOUS_ANNOTATION_KEY = "javaoperatorsdk.io/previous";
    private static final Logger log = LoggerFactory.getLogger(InformerEventSource.class);
    private final PrimaryToSecondaryIndex<R> primaryToSecondaryIndex;
    private final PrimaryToSecondaryMapper<P> primaryToSecondaryMapper;
    private final String id = UUID.randomUUID().toString();

    public InformerEventSource(InformerConfiguration<R> configuration, EventSourceContext<P> context) {
        this(configuration, context.getClient(), context.getControllerConfiguration().getConfigurationService().parseResourceVersionsForEventFilteringAndCaching());
    }

    public InformerEventSource(InformerConfiguration<R> configuration, KubernetesClient client) {
        this(configuration, client, false);
    }

    public InformerEventSource(InformerConfiguration<R> configuration, KubernetesClient client, boolean parseResourceVersions) {
        super(client.resources(configuration.getResourceClass()), configuration, parseResourceVersions);
        this.primaryToSecondaryMapper = configuration.getPrimaryToSecondaryMapper();
        this.primaryToSecondaryIndex = this.primaryToSecondaryMapper == null ? new DefaultPrimaryToSecondaryIndex<R>(configuration.getSecondaryToPrimaryMapper()) : NOOPPrimaryToSecondaryIndex.getInstance();
        this.onAddFilter = configuration.onAddFilter().orElse(null);
        this.onUpdateFilter = configuration.onUpdateFilter().orElse(null);
        this.onDeleteFilter = configuration.onDeleteFilter().orElse(null);
        this.genericFilter = configuration.genericFilter().orElse(null);
    }

    @Override
    public void onAdd(R newResource) {
        if (log.isDebugEnabled()) {
            log.debug("On add event received for resource id: {} type: {} version: {}", new Object[]{ResourceID.fromResource(newResource), this.resourceType().getSimpleName(), newResource.getMetadata().getResourceVersion()});
        }
        this.primaryToSecondaryIndex.onAddOrUpdate(newResource);
        this.onAddOrUpdate(Operation.ADD, newResource, null, () -> InformerEventSource.super.onAdd(newResource));
    }

    @Override
    public void onUpdate(R oldObject, R newObject) {
        if (log.isDebugEnabled()) {
            log.debug("On update event received for resource id: {} type: {} version: {} old version: {} ", new Object[]{ResourceID.fromResource(newObject), this.resourceType().getSimpleName(), newObject.getMetadata().getResourceVersion(), oldObject.getMetadata().getResourceVersion()});
        }
        this.primaryToSecondaryIndex.onAddOrUpdate(newObject);
        this.onAddOrUpdate(Operation.UPDATE, newObject, oldObject, () -> InformerEventSource.super.onUpdate(oldObject, newObject));
    }

    @Override
    public void onDelete(R resource, boolean b) {
        if (log.isDebugEnabled()) {
            log.debug("On delete event received for resource id: {} type: {}", (Object)ResourceID.fromResource(resource), (Object)this.resourceType().getSimpleName());
        }
        this.primaryToSecondaryIndex.onDelete(resource);
        super.onDelete(resource, b);
        if (this.acceptedByDeleteFilters(resource, b)) {
            this.propagateEvent(resource);
        }
    }

    private synchronized void onAddOrUpdate(Operation operation, R newObject, R oldObject, Runnable superOnOp) {
        ResourceID resourceID = ResourceID.fromResource(newObject);
        if (this.canSkipEvent(newObject, oldObject, resourceID)) {
            log.debug("Skipping event propagation for {}, since was a result of a reconcile action. Resource ID: {}", (Object)operation, (Object)ResourceID.fromResource(newObject));
            superOnOp.run();
        } else {
            superOnOp.run();
            if (this.eventAcceptedByFilter(operation, newObject, oldObject)) {
                log.debug("Propagating event for {}, resource with same version not result of a reconciliation. Resource ID: {}", (Object)operation, (Object)resourceID);
                this.propagateEvent(newObject);
            } else {
                log.debug("Event filtered out for operation: {}, resourceID: {}", (Object)operation, (Object)resourceID);
            }
        }
    }

    private boolean canSkipEvent(R newObject, R oldObject, ResourceID resourceID) {
        if (this.temporaryResourceCache.isKnownResourceVersion(newObject)) {
            return true;
        }
        Optional res = this.temporaryResourceCache.getResourceFromCache(resourceID);
        if (res.isEmpty()) {
            return this.isEventKnownFromAnnotation(newObject, oldObject);
        }
        boolean resVersionsEqual = newObject.getMetadata().getResourceVersion().equals(((HasMetadata)res.get()).getMetadata().getResourceVersion());
        log.debug("Resource found in temporal cache for id: {} resource versions equal: {}", (Object)resourceID, (Object)resVersionsEqual);
        return resVersionsEqual;
    }

    private boolean isEventKnownFromAnnotation(R newObject, R oldObject) {
        String[] parts;
        String previous = (String)newObject.getMetadata().getAnnotations().get(PREVIOUS_ANNOTATION_KEY);
        boolean known = false;
        if (previous != null && this.id.equals((parts = previous.split(","))[0])) {
            if (oldObject == null && parts.length == 1) {
                known = true;
            } else if (oldObject != null && parts.length == 2 && oldObject.getMetadata().getResourceVersion().equals(parts[1])) {
                known = true;
            }
        }
        return known;
    }

    private void propagateEvent(R object) {
        Set<ResourceID> primaryResourceIdSet = ((InformerConfiguration)this.configuration()).getSecondaryToPrimaryMapper().toPrimaryResourceIDs(object);
        if (primaryResourceIdSet.isEmpty()) {
            return;
        }
        primaryResourceIdSet.forEach(resourceId -> {
            Event event = new Event((ResourceID)resourceId);
            EventHandler eventHandler = this.getEventHandler();
            if (eventHandler != null) {
                eventHandler.handleEvent(event);
            }
        });
    }

    @Override
    public Set<R> getSecondaryResources(P primary) {
        Set<ResourceID> secondaryIDs;
        if (this.useSecondaryToPrimaryIndex()) {
            ResourceID primaryResourceID = ResourceID.fromResource(primary);
            secondaryIDs = this.primaryToSecondaryIndex.getSecondaryResources(primaryResourceID);
            log.debug("Using PrimaryToSecondaryIndex to find secondary resources for primary: {}. Found secondary ids: {} ", (Object)primaryResourceID, secondaryIDs);
        } else {
            secondaryIDs = this.primaryToSecondaryMapper.toSecondaryResourceIDs(primary);
            log.debug("Using PrimaryToSecondaryMapper to find secondary resources for primary: {}. Found secondary ids: {} ", primary, secondaryIDs);
        }
        return secondaryIDs.stream().map(this::get).flatMap(Optional::stream).collect(Collectors.toSet());
    }

    @Deprecated(forRemoval=true)
    public InformerConfiguration<R> getConfiguration() {
        return (InformerConfiguration)this.configuration();
    }

    @Override
    public synchronized void handleRecentResourceUpdate(ResourceID resourceID, R resource, R previousVersionOfResource) {
        this.handleRecentCreateOrUpdate(Operation.UPDATE, resource, previousVersionOfResource);
    }

    @Override
    public synchronized void handleRecentResourceCreate(ResourceID resourceID, R resource) {
        this.handleRecentCreateOrUpdate(Operation.ADD, resource, null);
    }

    private void handleRecentCreateOrUpdate(Operation operation, R newResource, R oldResource) {
        this.primaryToSecondaryIndex.onAddOrUpdate(newResource);
        this.temporaryResourceCache.putResource(newResource, Optional.ofNullable(oldResource).map(r -> r.getMetadata().getResourceVersion()).orElse(null));
    }

    private boolean useSecondaryToPrimaryIndex() {
        return this.primaryToSecondaryMapper == null;
    }

    @Override
    public boolean allowsNamespaceChanges() {
        return ((InformerConfiguration)this.configuration()).followControllerNamespaceChanges();
    }

    private boolean eventAcceptedByFilter(Operation operation, R newObject, R oldObject) {
        if (this.genericFilter != null && !this.genericFilter.accept(newObject)) {
            return false;
        }
        if (operation == Operation.ADD) {
            return this.onAddFilter == null || this.onAddFilter.accept(newObject);
        }
        return this.onUpdateFilter == null || this.onUpdateFilter.accept(newObject, oldObject);
    }

    private boolean acceptedByDeleteFilters(R resource, boolean b) {
        return !(this.onDeleteFilter != null && !this.onDeleteFilter.accept(resource, b) || this.genericFilter != null && !this.genericFilter.accept(resource));
    }

    public R addPreviousAnnotation(String resourceVersion, R target) {
        target.getMetadata().getAnnotations().put(PREVIOUS_ANNOTATION_KEY, this.id + Optional.ofNullable(resourceVersion).map(rv -> "," + rv).orElse(""));
        return target;
    }

    private static enum Operation {
        ADD,
        UPDATE;

    }
}

