/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.MissingCRDException;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.ExecutorServiceManager;
import io.javaoperatorsdk.operator.api.config.NamespaceChangeable;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceInitializer;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.LifecycleAware;
import io.javaoperatorsdk.operator.processing.event.EventSourceMetadata;
import io.javaoperatorsdk.operator.processing.event.EventSourceRetriever;
import io.javaoperatorsdk.operator.processing.event.EventSources;
import io.javaoperatorsdk.operator.processing.event.NamedEventSource;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.processing.event.source.EventSourceStartPriority;
import io.javaoperatorsdk.operator.processing.event.source.ResourceEventAware;
import io.javaoperatorsdk.operator.processing.event.source.ResourceEventSource;
import io.javaoperatorsdk.operator.processing.event.source.controller.ControllerResourceEventSource;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceAction;
import io.javaoperatorsdk.operator.processing.event.source.informer.ManagedInformerEventSource;
import io.javaoperatorsdk.operator.processing.event.source.timer.TimerEventSource;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSourceManager<P extends HasMetadata>
implements LifecycleAware,
EventSourceRetriever<P> {
    private static final Logger log = LoggerFactory.getLogger(EventSourceManager.class);
    private final EventSources<P> eventSources;
    private final Controller<P> controller;
    private final ExecutorServiceManager executorServiceManager;

    public EventSourceManager(Controller<P> controller) {
        this(controller, new EventSources());
    }

    EventSourceManager(Controller<P> controller, EventSources<P> eventSources) {
        this.eventSources = eventSources;
        this.controller = controller;
        this.executorServiceManager = controller.getExecutorServiceManager();
        eventSources.createControllerEventSource(controller);
        this.postProcessDefaultEventSourcesAfterProcessorInitializer();
    }

    public void postProcessDefaultEventSourcesAfterProcessorInitializer() {
        this.eventSources.controllerResourceEventSource().setEventHandler(this.controller.getEventProcessor());
        this.eventSources.retryEventSource().setEventHandler(this.controller.getEventProcessor());
    }

    @Override
    public synchronized void start() {
        this.startEventSource(this.eventSources.namedControllerResourceEventSource());
        this.executorServiceManager.boundedExecuteAndWaitForAllToComplete(this.eventSources.additionalNamedEventSources().filter(es -> es.priority().equals((Object)EventSourceStartPriority.RESOURCE_STATE_LOADER)), this::startEventSource, EventSourceManager.getThreadNamer("start"));
        this.executorServiceManager.boundedExecuteAndWaitForAllToComplete(this.eventSources.additionalNamedEventSources().filter(es -> es.priority().equals((Object)EventSourceStartPriority.DEFAULT)), this::startEventSource, EventSourceManager.getThreadNamer("start"));
    }

    private static Function<NamedEventSource, String> getThreadNamer(String stage) {
        return es -> {
            String name = es.name();
            return es.priority() + " " + stage + " -> " + (es.isNameSet() ? name + " " + es.original().getClass() : es.original());
        };
    }

    private static Function<NamespaceChangeable, String> getEventSourceThreadNamer(String stage) {
        return es -> stage + " -> " + es;
    }

    @Override
    public synchronized void stop() {
        this.stopEventSource(this.eventSources.namedControllerResourceEventSource());
        this.executorServiceManager.boundedExecuteAndWaitForAllToComplete(this.eventSources.additionalNamedEventSources(), this::stopEventSource, EventSourceManager.getThreadNamer("stop"));
    }

    private void logEventSourceEvent(NamedEventSource eventSource, String event) {
        if (log.isDebugEnabled()) {
            if (eventSource.original() instanceof ResourceEventSource) {
                ResourceEventSource source = (ResourceEventSource)eventSource.original();
                log.debug("{} event source {} for {}", new Object[]{event, eventSource.isNameSet() ? eventSource.name() : eventSource, source.resourceType()});
            } else {
                log.debug("{} event source {}", (Object)event, eventSource.isNameSet() ? eventSource.name() : eventSource);
            }
        }
    }

    private Void startEventSource(NamedEventSource eventSource) {
        try {
            this.logEventSourceEvent(eventSource, "Starting");
            eventSource.start();
            this.logEventSourceEvent(eventSource, "Started");
        }
        catch (MissingCRDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OperatorException("Couldn't start source " + eventSource.name(), e);
        }
        return null;
    }

    private Void stopEventSource(NamedEventSource eventSource) {
        try {
            this.logEventSourceEvent(eventSource, "Stopping");
            eventSource.stop();
            this.logEventSourceEvent(eventSource, "Stopped");
        }
        catch (Exception e) {
            log.warn("Error closing {} -> {}", (Object)eventSource.name(), (Object)e);
        }
        return null;
    }

    public final void registerEventSource(EventSource eventSource) throws OperatorException {
        this.registerEventSource(null, eventSource);
    }

    public final synchronized void registerEventSource(String name, EventSource eventSource) throws OperatorException {
        Objects.requireNonNull(eventSource, "EventSource must not be null");
        try {
            if (name == null || name.isBlank()) {
                name = EventSourceInitializer.generateNameFor(eventSource);
            }
            if (eventSource instanceof ManagedInformerEventSource) {
                ManagedInformerEventSource managedInformerEventSource = (ManagedInformerEventSource)eventSource;
                managedInformerEventSource.setConfigurationService(this.controller.getConfiguration().getConfigurationService());
            }
            NamedEventSource named = new NamedEventSource(eventSource, name);
            this.eventSources.add(named);
            named.setEventHandler(this.controller.getEventProcessor());
        }
        catch (MissingCRDException | IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OperatorException("Couldn't register event source: " + name + " for " + this.controller.getConfiguration().getName() + " controller", e);
        }
    }

    public void broadcastOnResourceEvent(ResourceAction action, P resource, P oldResource) {
        this.eventSources.additionalNamedEventSources().map(NamedEventSource::original).forEach(source -> {
            if (source instanceof ResourceEventAware) {
                ResourceEventAware lifecycleAwareES = (ResourceEventAware)((Object)source);
                switch (action) {
                    case ADDED: {
                        lifecycleAwareES.onResourceCreated(resource);
                        break;
                    }
                    case UPDATED: {
                        lifecycleAwareES.onResourceUpdated(resource, oldResource);
                        break;
                    }
                    case DELETED: {
                        lifecycleAwareES.onResourceDeleted(resource);
                    }
                }
            }
        });
    }

    public void changeNamespaces(Set<String> namespaces) {
        this.eventSources.controllerResourceEventSource().changeNamespaces(namespaces);
        this.executorServiceManager.boundedExecuteAndWaitForAllToComplete(this.eventSources.additionalEventSources().filter(NamespaceChangeable.class::isInstance).map(NamespaceChangeable.class::cast).filter(NamespaceChangeable::allowsNamespaceChanges), e -> {
            e.changeNamespaces(namespaces);
            return null;
        }, EventSourceManager.getEventSourceThreadNamer("changeNamespace"));
    }

    public Set<EventSource> getRegisteredEventSources() {
        return this.eventSources.flatMappedSources().map(NamedEventSource::original).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Map<String, EventSource> allEventSources() {
        return this.eventSources.allNamedEventSources().collect(Collectors.toMap(NamedEventSource::name, NamedEventSource::original));
    }

    public Stream<? extends EventSourceMetadata> getNamedEventSourcesStream() {
        return this.eventSources.flatMappedSources();
    }

    public ControllerResourceEventSource<P> getControllerResourceEventSource() {
        return this.eventSources.controllerResourceEventSource();
    }

    @Override
    public <R> List<ResourceEventSource<R, P>> getResourceEventSourcesFor(Class<R> dependentType) {
        return this.eventSources.getEventSources(dependentType);
    }

    @Override
    public synchronized EventSource dynamicallyRegisterEventSource(String name, EventSource eventSource) {
        NamedEventSource es = this.eventSources.existing(name, eventSource);
        if (es != null) {
            return es;
        }
        this.registerEventSource(name, eventSource);
        eventSource.start();
        return eventSource;
    }

    @Override
    public synchronized Optional<EventSource> dynamicallyDeRegisterEventSource(String name) {
        EventSource es = this.eventSources.remove(name);
        if (es != null) {
            es.stop();
        }
        return Optional.ofNullable(es);
    }

    @Override
    public EventSourceContext<P> eventSourceContextForDynamicRegistration() {
        return this.controller.eventSourceContext();
    }

    @Deprecated
    public <R> List<ResourceEventSource<R, P>> getEventSourcesFor(Class<R> dependentType) {
        return this.getResourceEventSourcesFor(dependentType);
    }

    @Override
    public <R> ResourceEventSource<R, P> getResourceEventSourceFor(Class<R> dependentType, String qualifier) {
        Objects.requireNonNull(dependentType, "dependentType is Mandatory");
        return this.eventSources.get(dependentType, qualifier);
    }

    TimerEventSource<P> retryEventSource() {
        return this.eventSources.retryEventSource();
    }

    Controller<P> getController() {
        return this.controller;
    }
}

