/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.workflow;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.api.reconciler.dependent.EventSourceReferencer;
import io.javaoperatorsdk.operator.api.reconciler.dependent.managed.KubernetesClientAware;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DefaultWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DependentResourceNode;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultManagedWorkflow<P extends HasMetadata>
implements ManagedWorkflow<P> {
    private final Set<String> topLevelResources;
    private final Set<String> bottomLevelResources;
    private final List<DependentResourceSpec> orderedSpecs;
    private final boolean hasCleaner;

    protected DefaultManagedWorkflow(List<DependentResourceSpec> orderedSpecs, boolean hasCleaner) {
        this.hasCleaner = hasCleaner;
        this.topLevelResources = new HashSet<String>(orderedSpecs.size());
        this.bottomLevelResources = orderedSpecs.stream().map(DependentResourceSpec::getName).collect(Collectors.toSet());
        this.orderedSpecs = orderedSpecs;
        for (DependentResourceSpec spec : orderedSpecs) {
            if (spec.getDependsOn().isEmpty()) {
                this.topLevelResources.add(spec.getName());
                continue;
            }
            for (String dependsOn : spec.getDependsOn()) {
                this.bottomLevelResources.remove(dependsOn);
            }
        }
    }

    @Override
    public List<DependentResourceSpec> getOrderedSpecs() {
        return this.orderedSpecs;
    }

    protected Set<String> getTopLevelResources() {
        return this.topLevelResources;
    }

    protected Set<String> getBottomLevelResources() {
        return this.bottomLevelResources;
    }

    List<String> nodeNames() {
        return this.orderedSpecs.stream().map(DependentResourceSpec::getName).collect(Collectors.toList());
    }

    @Override
    public boolean hasCleaner() {
        return this.hasCleaner;
    }

    @Override
    public boolean isEmpty() {
        return this.orderedSpecs.isEmpty();
    }

    @Override
    public Workflow<P> resolve(KubernetesClient client, ControllerConfiguration<P> configuration) {
        HashMap<String, DependentResourceNode> alreadyResolved = new HashMap<String, DependentResourceNode>(this.orderedSpecs.size());
        for (DependentResourceSpec spec : this.orderedSpecs) {
            DependentResourceNode node = new DependentResourceNode(spec.getName(), spec.getReconcileCondition(), spec.getDeletePostCondition(), spec.getReadyCondition(), spec.getActivationCondition(), this.resolve(spec, client, configuration));
            alreadyResolved.put(node.getName(), node);
            spec.getDependsOn().forEach(depend -> node.addDependsOnRelation((DependentResourceNode)alreadyResolved.get((String)depend)));
        }
        Set<DependentResourceNode> bottom = this.bottomLevelResources.stream().map(alreadyResolved::get).collect(Collectors.toSet());
        Set<DependentResourceNode> top = this.topLevelResources.stream().map(alreadyResolved::get).collect(Collectors.toSet());
        return new DefaultWorkflow(alreadyResolved, bottom, top, true, this.hasCleaner);
    }

    private <R> DependentResource<R, P> resolve(DependentResourceSpec<R, P> spec, KubernetesClient client, ControllerConfiguration<P> configuration) {
        DependentResource dependentResource = configuration.getConfigurationService().dependentResourceFactory().createFrom(spec, configuration);
        if (dependentResource instanceof KubernetesClientAware) {
            ((KubernetesClientAware)((Object)dependentResource)).setKubernetesClient(client);
        }
        spec.getUseEventSourceWithName().ifPresent(esName -> {
            if (!(dependentResource instanceof EventSourceReferencer)) {
                throw new IllegalStateException("DependentResource " + spec + " wants to use EventSource named " + esName + " but doesn't implement support for this feature by implementing " + EventSourceReferencer.class.getSimpleName());
            }
            ((EventSourceReferencer)((Object)dependentResource)).useEventSourceWithName((String)esName);
        });
        return dependentResource;
    }
}

