/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnDeleteFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import java.util.Set;

public final class KubernetesDependentResourceConfigBuilder<R> {
    private Set<String> namespaces = Constants.SAME_AS_CONTROLLER_NAMESPACES_SET;
    private String labelSelector;
    private boolean createResourceOnlyIfNotExistingWithSSA;
    private ResourceDiscriminator<R, ?> resourceDiscriminator;
    private Boolean useSSA;
    private OnAddFilter<R> onAddFilter;
    private OnUpdateFilter<R> onUpdateFilter;
    private OnDeleteFilter<R> onDeleteFilter;
    private GenericFilter<R> genericFilter;

    public static <R> KubernetesDependentResourceConfigBuilder<R> aKubernetesDependentResourceConfig() {
        return new KubernetesDependentResourceConfigBuilder<R>();
    }

    public KubernetesDependentResourceConfigBuilder<R> withNamespaces(Set<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public KubernetesDependentResourceConfigBuilder<R> withLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    public KubernetesDependentResourceConfigBuilder<R> withCreateResourceOnlyIfNotExistingWithSSA(boolean createResourceOnlyIfNotExistingWithSSA) {
        this.createResourceOnlyIfNotExistingWithSSA = createResourceOnlyIfNotExistingWithSSA;
        return this;
    }

    public KubernetesDependentResourceConfigBuilder<R> withResourceDiscriminator(ResourceDiscriminator<R, ?> resourceDiscriminator) {
        this.resourceDiscriminator = resourceDiscriminator;
        return this;
    }

    public KubernetesDependentResourceConfigBuilder<R> withUseSSA(Boolean useSSA) {
        this.useSSA = useSSA;
        return this;
    }

    public KubernetesDependentResourceConfigBuilder<R> withOnAddFilter(OnAddFilter<R> onAddFilter) {
        this.onAddFilter = onAddFilter;
        return this;
    }

    public KubernetesDependentResourceConfigBuilder<R> withOnUpdateFilter(OnUpdateFilter<R> onUpdateFilter) {
        this.onUpdateFilter = onUpdateFilter;
        return this;
    }

    public KubernetesDependentResourceConfigBuilder<R> withOnDeleteFilter(OnDeleteFilter<R> onDeleteFilter) {
        this.onDeleteFilter = onDeleteFilter;
        return this;
    }

    public KubernetesDependentResourceConfigBuilder<R> withGenericFilter(GenericFilter<R> genericFilter) {
        this.genericFilter = genericFilter;
        return this;
    }

    public KubernetesDependentResourceConfig<R> build() {
        return new KubernetesDependentResourceConfig<R>(this.namespaces, this.labelSelector, this.namespaces != Constants.SAME_AS_CONTROLLER_NAMESPACES_SET, this.createResourceOnlyIfNotExistingWithSSA, this.resourceDiscriminator, this.useSSA, this.onAddFilter, this.onUpdateFilter, this.onDeleteFilter, this.genericFilter);
    }
}

