/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.core;

import io.debezium.operator.api.model.DebeziumServer;
import io.debezium.operator.api.model.status.Condition;
import io.debezium.operator.api.model.status.DebeziumServerStatus;
import io.debezium.operator.core.dependent.ConfigMapDependent;
import io.debezium.operator.core.dependent.DeploymentDependent;
import io.debezium.operator.core.dependent.JmxServiceDependent;
import io.debezium.operator.core.dependent.RoleBindingDependent;
import io.debezium.operator.core.dependent.RoleDependent;
import io.debezium.operator.core.dependent.ServiceAccountDependent;
import io.debezium.operator.core.dependent.conditions.CreateServiceAccount;
import io.debezium.operator.core.dependent.conditions.DeploymentReady;
import io.debezium.operator.core.dependent.conditions.JmxEnabled;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Dependent;
import io.quarkiverse.operatorsdk.annotations.CSVMetadata;
import io.quarkiverse.operatorsdk.annotations.RBACRule;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.logging.Logger;

@ControllerConfiguration(namespaces={"JOSDK_WATCH_CURRENT"}, name="debeziumserver", dependents={@Dependent(name="service-account", type=ServiceAccountDependent.class, reconcilePrecondition=CreateServiceAccount.class), @Dependent(name="role", type=RoleDependent.class), @Dependent(name="role-binding", type=RoleBindingDependent.class, dependsOn={"service-account", "role"}), @Dependent(name="config", type=ConfigMapDependent.class), @Dependent(name="deployment", type=DeploymentDependent.class, dependsOn={"config", "role-binding"}, readyPostcondition=DeploymentReady.class), @Dependent(name="jmx-service", type=JmxServiceDependent.class, dependsOn={"deployment"}, reconcilePrecondition=JmxEnabled.class)})
@CSVMetadata(name="${olm.bundle.name}")
@RBACRule(verbs={"get", "list", "watch"}, apiGroups={""}, resources={"secrets"})
public class DebeziumServerReconciler
implements Reconciler<DebeziumServer> {
    private static final Logger quarkusSyntheticLogger = Logger.getLogger((String)"io.debezium.operator.core.DebeziumServerReconciler");

    public UpdateControl<DebeziumServer> reconcile(DebeziumServer debeziumServer, Context<DebeziumServer> context) {
        String name = debeziumServer.getMetadata().getName();
        return context.managedDependentResourceContext().getWorkflowReconcileResult().map(result -> {
            if (result.allDependentResourcesReady()) {
                quarkusSyntheticLogger.infof("Server %s is ready", (Object)name);
                this.initializeReadyStatus(debeziumServer);
                return UpdateControl.patchStatus((HasMetadata)debeziumServer);
            }
            Duration delay = Duration.ofSeconds(10L);
            Long l = delay.toSeconds();
            String string = name;
            String string2 = "Server %s not ready yet, rescheduling after %ds";
            quarkusSyntheticLogger.infof(string2, (Object)string, (Object)l);
            this.initializeNotReadyStatus(debeziumServer);
            return (UpdateControl)UpdateControl.patchStatus((HasMetadata)debeziumServer).rescheduleAfter(delay);
        }).orElseThrow();
    }

    private void initializeReadyStatus(DebeziumServer debeziumServer) {
        Condition condition = new Condition();
        condition.setType("Ready");
        condition.setStatus("True");
        condition.setMessage("Server %s is ready".formatted(debeziumServer.getMetadata().getName()));
        this.initializeConditions(debeziumServer, condition);
    }

    private void initializeNotReadyStatus(DebeziumServer debeziumServer) {
        Condition condition = new Condition();
        condition.setType("Ready");
        condition.setStatus("False");
        condition.setMessage("Server %s deployment in progress".formatted(debeziumServer.getMetadata().getName()));
        this.initializeConditions(debeziumServer, condition);
    }

    private void initializeConditions(DebeziumServer debeziumServer, Condition ... conditions) {
        ArrayList<Condition> list = new ArrayList<Condition>(Arrays.asList(conditions));
        DebeziumServerStatus status = new DebeziumServerStatus();
        status.setConditions(list);
        debeziumServer.setStatus((Object)status);
    }
}

