/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model;

import io.debezium.operator.api.model.DebeziumServerSpec;
import io.debezium.operator.api.model.Format;
import io.debezium.operator.api.model.Predicate;
import io.debezium.operator.api.model.Quarkus;
import io.debezium.operator.api.model.Runtime;
import io.debezium.operator.api.model.Sink;
import io.debezium.operator.api.model.Source;
import io.debezium.operator.api.model.Storage;
import io.debezium.operator.api.model.Transformation;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DebeziumServerSpecFluent<A extends DebeziumServerSpecFluent<A>>
extends BaseFluent<A> {
    private String image;
    private String version;
    private Storage storage;
    private Sink sink;
    private Source source;
    private Format format;
    private Quarkus quarkus;
    private Runtime runtime;
    private List<Transformation> transforms = new ArrayList<Transformation>();
    private Map<String, Predicate> predicates;

    public DebeziumServerSpecFluent() {
    }

    public DebeziumServerSpecFluent(DebeziumServerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DebeziumServerSpec instance) {
        DebeziumServerSpec debeziumServerSpec = instance = instance != null ? instance : new DebeziumServerSpec();
        if (instance != null) {
            this.withImage(instance.getImage());
            this.withVersion(instance.getVersion());
            this.withStorage(instance.getStorage());
            this.withSink(instance.getSink());
            this.withSource(instance.getSource());
            this.withFormat(instance.getFormat());
            this.withQuarkus(instance.getQuarkus());
            this.withRuntime(instance.getRuntime());
            this.withTransforms(instance.getTransforms());
            this.withPredicates(instance.getPredicates());
        }
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public A withStorage(Storage storage) {
        this.storage = storage;
        return (A)((Object)this);
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public Sink getSink() {
        return this.sink;
    }

    public A withSink(Sink sink) {
        this.sink = sink;
        return (A)((Object)this);
    }

    public boolean hasSink() {
        return this.sink != null;
    }

    public Source getSource() {
        return this.source;
    }

    public A withSource(Source source) {
        this.source = source;
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public Format getFormat() {
        return this.format;
    }

    public A withFormat(Format format) {
        this.format = format;
        return (A)((Object)this);
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public Quarkus getQuarkus() {
        return this.quarkus;
    }

    public A withQuarkus(Quarkus quarkus) {
        this.quarkus = quarkus;
        return (A)((Object)this);
    }

    public boolean hasQuarkus() {
        return this.quarkus != null;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public A withRuntime(Runtime runtime) {
        this.runtime = runtime;
        return (A)((Object)this);
    }

    public boolean hasRuntime() {
        return this.runtime != null;
    }

    public A addToTransforms(int index, Transformation item) {
        if (this.transforms == null) {
            this.transforms = new ArrayList<Transformation>();
        }
        this.transforms.add(index, item);
        return (A)((Object)this);
    }

    public A setToTransforms(int index, Transformation item) {
        if (this.transforms == null) {
            this.transforms = new ArrayList<Transformation>();
        }
        this.transforms.set(index, item);
        return (A)((Object)this);
    }

    public A addToTransforms(Transformation ... items) {
        if (this.transforms == null) {
            this.transforms = new ArrayList<Transformation>();
        }
        for (Transformation item : items) {
            this.transforms.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTransforms(Collection<Transformation> items) {
        if (this.transforms == null) {
            this.transforms = new ArrayList<Transformation>();
        }
        for (Transformation item : items) {
            this.transforms.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTransforms(Transformation ... items) {
        if (this.transforms == null) {
            return (A)((Object)this);
        }
        for (Transformation item : items) {
            this.transforms.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTransforms(Collection<Transformation> items) {
        if (this.transforms == null) {
            return (A)((Object)this);
        }
        for (Transformation item : items) {
            this.transforms.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Transformation> getTransforms() {
        return this.transforms;
    }

    public Transformation getTransform(int index) {
        return this.transforms.get(index);
    }

    public Transformation getFirstTransform() {
        return this.transforms.get(0);
    }

    public Transformation getLastTransform() {
        return this.transforms.get(this.transforms.size() - 1);
    }

    public Transformation getMatchingTransform(java.util.function.Predicate<Transformation> predicate) {
        for (Transformation item : this.transforms) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTransform(java.util.function.Predicate<Transformation> predicate) {
        for (Transformation item : this.transforms) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTransforms(List<Transformation> transforms) {
        if (transforms != null) {
            this.transforms = new ArrayList<Transformation>();
            for (Transformation item : transforms) {
                this.addToTransforms(item);
            }
        } else {
            this.transforms = null;
        }
        return (A)((Object)this);
    }

    public A withTransforms(Transformation ... transforms) {
        if (this.transforms != null) {
            this.transforms.clear();
            this._visitables.remove((Object)"transforms");
        }
        if (transforms != null) {
            for (Transformation item : transforms) {
                this.addToTransforms(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTransforms() {
        return this.transforms != null && !this.transforms.isEmpty();
    }

    public A addToPredicates(String key, Predicate value) {
        if (this.predicates == null && key != null && value != null) {
            this.predicates = new LinkedHashMap<String, Predicate>();
        }
        if (key != null && value != null) {
            this.predicates.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPredicates(Map<String, Predicate> map) {
        if (this.predicates == null && map != null) {
            this.predicates = new LinkedHashMap<String, Predicate>();
        }
        if (map != null) {
            this.predicates.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromPredicates(String key) {
        if (this.predicates == null) {
            return (A)((Object)this);
        }
        if (key != null && this.predicates != null) {
            this.predicates.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromPredicates(Map<String, Predicate> map) {
        if (this.predicates == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.predicates == null) continue;
                this.predicates.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Predicate> getPredicates() {
        return this.predicates;
    }

    public <K, V> A withPredicates(Map<String, Predicate> predicates) {
        this.predicates = predicates == null ? null : new LinkedHashMap<String, Predicate>(predicates);
        return (A)((Object)this);
    }

    public boolean hasPredicates() {
        return this.predicates != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DebeziumServerSpecFluent that = (DebeziumServerSpecFluent)((Object)o);
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.sink, that.sink)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.format, that.format)) {
            return false;
        }
        if (!Objects.equals(this.quarkus, that.quarkus)) {
            return false;
        }
        if (!Objects.equals(this.runtime, that.runtime)) {
            return false;
        }
        if (!Objects.equals(this.transforms, that.transforms)) {
            return false;
        }
        return Objects.equals(this.predicates, that.predicates);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.version, this.storage, this.sink, this.source, this.format, this.quarkus, this.runtime, this.transforms, this.predicates, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.sink != null) {
            sb.append("sink:");
            sb.append(this.sink + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.format != null) {
            sb.append("format:");
            sb.append(this.format + ",");
        }
        if (this.quarkus != null) {
            sb.append("quarkus:");
            sb.append(this.quarkus + ",");
        }
        if (this.runtime != null) {
            sb.append("runtime:");
            sb.append(this.runtime + ",");
        }
        if (this.transforms != null && !this.transforms.isEmpty()) {
            sb.append("transforms:");
            sb.append(this.transforms + ",");
        }
        if (this.predicates != null && !this.predicates.isEmpty()) {
            sb.append("predicates:");
            sb.append(this.predicates);
        }
        sb.append("}");
        return sb.toString();
    }
}

