/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;

public class InternalEventFilters {
    private InternalEventFilters() {
    }

    static <T extends HasMetadata> OnUpdateFilter<T> onUpdateMarkedForDeletion() {
        return (newResource, oldResource) -> newResource.isMarkedForDeletion();
    }

    static <T extends HasMetadata> OnUpdateFilter<T> onUpdateGenerationAware(boolean generationAware) {
        return (newResource, oldResource) -> {
            if (!generationAware) {
                return true;
            }
            if (oldResource.getMetadata().getGeneration() == null) {
                return true;
            }
            return oldResource.getMetadata().getGeneration() < newResource.getMetadata().getGeneration();
        };
    }

    static <T extends HasMetadata> OnUpdateFilter<T> onUpdateFinalizerNeededAndApplied(boolean useFinalizer, String finalizerName) {
        return (newResource, oldResource) -> {
            if (useFinalizer) {
                boolean oldFinalizer = oldResource.hasFinalizer(finalizerName);
                boolean newFinalizer = newResource.hasFinalizer(finalizerName);
                return !newFinalizer || !oldFinalizer;
            }
            return false;
        };
    }
}

