/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.ObservedGenerationAware;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.BaseControl;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.DefaultContext;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.KubernetesResourceUtils;
import io.javaoperatorsdk.operator.processing.event.ExecutionScope;
import io.javaoperatorsdk.operator.processing.event.PostExecutionControl;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReconciliationDispatcher<P extends HasMetadata> {
    public static final int MAX_UPDATE_RETRY = 10;
    private static final Logger log = LoggerFactory.getLogger(ReconciliationDispatcher.class);
    private final Controller<P> controller;
    private final CustomResourceFacade<P> customResourceFacade;
    private final boolean retryConfigurationHasZeroAttempts;
    private final Cloner cloner;

    ReconciliationDispatcher(Controller<P> controller, CustomResourceFacade<P> customResourceFacade) {
        this.controller = controller;
        this.customResourceFacade = customResourceFacade;
        this.cloner = controller.getConfiguration().getConfigurationService().getResourceCloner();
        Retry retry = controller.getConfiguration().getRetry();
        this.retryConfigurationHasZeroAttempts = retry == null || retry.initExecution().isLastAttempt();
    }

    public ReconciliationDispatcher(Controller<P> controller) {
        this(controller, new CustomResourceFacade<P>(controller.getCRClient()));
    }

    public PostExecutionControl<P> handleExecution(ExecutionScope<P> executionScope) {
        try {
            return this.handleDispatch(executionScope);
        }
        catch (Exception e) {
            log.error("Error during event processing {} failed.", executionScope, (Object)e);
            return PostExecutionControl.exceptionDuringExecution(e);
        }
    }

    private PostExecutionControl<P> handleDispatch(ExecutionScope<P> executionScope) throws Exception {
        P originalResource = executionScope.getResource();
        P resourceForExecution = this.cloneResource(originalResource);
        log.debug("Handling dispatch for resource {}", (Object)KubernetesResourceUtils.getName(originalResource));
        boolean markedForDeletion = originalResource.isMarkedForDeletion();
        if (markedForDeletion && this.shouldNotDispatchToCleanupWhenMarkedForDeletion(originalResource)) {
            log.debug("Skipping cleanup of resource {} because finalizer(s) {} don't allow processing yet", (Object)KubernetesResourceUtils.getName(originalResource), (Object)originalResource.getMetadata().getFinalizers());
            return PostExecutionControl.defaultDispatch();
        }
        DefaultContext<P> context = new DefaultContext<P>(executionScope.getRetryInfo(), this.controller, originalResource);
        if (markedForDeletion) {
            return this.handleCleanup(resourceForExecution, context);
        }
        return this.handleReconcile(executionScope, resourceForExecution, originalResource, context);
    }

    private boolean shouldNotDispatchToCleanupWhenMarkedForDeletion(P resource) {
        boolean alreadyRemovedFinalizer;
        boolean bl = alreadyRemovedFinalizer = this.controller.useFinalizer() && !resource.hasFinalizer(this.configuration().getFinalizerName());
        if (alreadyRemovedFinalizer) {
            log.warn("This should not happen. Marked for deletion & already removed finalizer: {}", (Object)ResourceID.fromResource(resource));
        }
        return !this.controller.useFinalizer() || alreadyRemovedFinalizer;
    }

    private PostExecutionControl<P> handleReconcile(ExecutionScope<P> executionScope, P resourceForExecution, P originalResource, Context<P> context) throws Exception {
        if (this.controller.useFinalizer() && !originalResource.hasFinalizer(this.configuration().getFinalizerName())) {
            P updatedResource = this.updateCustomResourceWithFinalizer(resourceForExecution, originalResource);
            return PostExecutionControl.onlyFinalizerAdded(updatedResource);
        }
        try {
            return this.reconcileExecution(executionScope, resourceForExecution, originalResource, context);
        }
        catch (Exception e) {
            return this.handleErrorStatusHandler(resourceForExecution, originalResource, context, e);
        }
    }

    private P cloneResource(P resource) {
        return this.cloner.clone(resource);
    }

    private PostExecutionControl<P> reconcileExecution(ExecutionScope<P> executionScope, P resourceForExecution, P originalResource, Context<P> context) throws Exception {
        log.debug("Reconciling resource {} with version: {} with execution scope: {}", new Object[]{KubernetesResourceUtils.getName(resourceForExecution), KubernetesResourceUtils.getVersion(resourceForExecution), executionScope});
        UpdateControl<P> updateControl = this.controller.reconcile(resourceForExecution, context);
        P updatedCustomResource = null;
        if (updateControl.isUpdateResourceAndStatus()) {
            updatedCustomResource = this.updateCustomResource(updateControl.getResource());
            updateControl.getResource().getMetadata().setResourceVersion(updatedCustomResource.getMetadata().getResourceVersion());
            updatedCustomResource = this.updateStatusGenerationAware(updateControl.getResource(), originalResource, updateControl.isPatchStatus());
        } else if (updateControl.isUpdateStatus()) {
            updatedCustomResource = this.updateStatusGenerationAware(updateControl.getResource(), originalResource, updateControl.isPatchStatus());
        } else if (updateControl.isUpdateResource()) {
            updatedCustomResource = this.updateCustomResource(updateControl.getResource());
            if (this.shouldUpdateObservedGenerationAutomatically(updatedCustomResource)) {
                updatedCustomResource = this.updateStatusGenerationAware(updateControl.getResource(), originalResource, updateControl.isPatchStatus());
            }
        } else if (updateControl.isNoUpdate() && this.shouldUpdateObservedGenerationAutomatically(resourceForExecution)) {
            updatedCustomResource = this.updateStatusGenerationAware(originalResource, originalResource, updateControl.isPatchStatus());
        }
        return this.createPostExecutionControl(updatedCustomResource, updateControl);
    }

    private PostExecutionControl<P> handleErrorStatusHandler(P resource, P originalResource, Context<P> context, Exception e) throws Exception {
        if (this.isErrorStatusHandlerPresent()) {
            try {
                RetryInfo retryInfo = context.getRetryInfo().orElseGet(() -> new RetryInfo(){

                    @Override
                    public int getAttemptCount() {
                        return 0;
                    }

                    @Override
                    public boolean isLastAttempt() {
                        return ReconciliationDispatcher.this.retryConfigurationHasZeroAttempts || ReconciliationDispatcher.this.controller.getConfiguration().getRetry() == null;
                    }
                });
                ((DefaultContext)context).setRetryInfo(retryInfo);
                ErrorStatusUpdateControl<P> errorStatusUpdateControl = ((ErrorStatusHandler)((Object)this.controller.getReconciler())).updateErrorStatus(resource, context, e);
                HasMetadata updatedResource = null;
                if (errorStatusUpdateControl.getResource().isPresent()) {
                    HasMetadata hasMetadata = updatedResource = errorStatusUpdateControl.isPatch() ? this.customResourceFacade.patchStatus((HasMetadata)errorStatusUpdateControl.getResource().orElseThrow(), originalResource) : this.customResourceFacade.updateStatus((HasMetadata)errorStatusUpdateControl.getResource().orElseThrow());
                }
                if (errorStatusUpdateControl.isNoRetry()) {
                    PostExecutionControl<Object> postExecutionControl = updatedResource != null ? (errorStatusUpdateControl.isPatch() ? PostExecutionControl.customResourceStatusPatched(updatedResource) : PostExecutionControl.customResourceUpdated(updatedResource)) : PostExecutionControl.defaultDispatch();
                    errorStatusUpdateControl.getScheduleDelay().ifPresent(postExecutionControl::withReSchedule);
                    return postExecutionControl;
                }
            }
            catch (RuntimeException ex) {
                log.error("Error during error status handling.", (Throwable)ex);
            }
        }
        throw e;
    }

    private boolean isErrorStatusHandlerPresent() {
        return this.controller.getReconciler() instanceof ErrorStatusHandler;
    }

    private P updateStatusGenerationAware(P resource, P originalResource, boolean patch) {
        this.updateStatusObservedGenerationIfRequired(resource);
        if (patch) {
            return this.customResourceFacade.patchStatus(resource, originalResource);
        }
        return this.customResourceFacade.updateStatus(resource);
    }

    private boolean shouldUpdateObservedGenerationAutomatically(P resource) {
        CustomResource customResource;
        Object status;
        if (this.configuration().isGenerationAware() && resource instanceof CustomResource && (status = (customResource = (CustomResource)resource).getStatus()) instanceof ObservedGenerationAware) {
            Long observedGen = ((ObservedGenerationAware)status).getObservedGeneration();
            Long currentGen = resource.getMetadata().getGeneration();
            return !currentGen.equals(observedGen);
        }
        return false;
    }

    private void updateStatusObservedGenerationIfRequired(P resource) {
        CustomResource customResource;
        Object status;
        if (this.configuration().isGenerationAware() && resource instanceof CustomResource && (status = (customResource = (CustomResource)resource).getStatus()) instanceof ObservedGenerationAware) {
            ((ObservedGenerationAware)status).setObservedGeneration(resource.getMetadata().getGeneration());
        }
    }

    private PostExecutionControl<P> createPostExecutionControl(P updatedCustomResource, UpdateControl<P> updateControl) {
        PostExecutionControl<Object> postExecutionControl = updatedCustomResource != null ? (updateControl.isUpdateStatus() && updateControl.isPatchStatus() ? PostExecutionControl.customResourceStatusPatched(updatedCustomResource) : PostExecutionControl.customResourceUpdated(updatedCustomResource)) : PostExecutionControl.defaultDispatch();
        this.updatePostExecutionControlWithReschedule(postExecutionControl, updateControl);
        return postExecutionControl;
    }

    private void updatePostExecutionControlWithReschedule(PostExecutionControl<P> postExecutionControl, BaseControl<?> baseControl) {
        baseControl.getScheduleDelay().ifPresent(postExecutionControl::withReSchedule);
    }

    private PostExecutionControl<P> handleCleanup(P resource, Context<P> context) {
        log.debug("Executing delete for resource: {} with version: {}", (Object)KubernetesResourceUtils.getName(resource), (Object)KubernetesResourceUtils.getVersion(resource));
        DeleteControl deleteControl = this.controller.cleanup(resource, context);
        boolean useFinalizer = this.controller.useFinalizer();
        if (useFinalizer) {
            String finalizerName = this.configuration().getFinalizerName();
            if (deleteControl.isRemoveFinalizer() && resource.hasFinalizer(finalizerName)) {
                HasMetadata customResource = this.conflictRetryingUpdate(resource, r -> {
                    if (r == null) {
                        log.warn("Could not remove finalizer on null resource: {} with version: {}", (Object)KubernetesResourceUtils.getUID(resource), (Object)KubernetesResourceUtils.getVersion(resource));
                        return false;
                    }
                    return r.removeFinalizer(finalizerName);
                });
                return PostExecutionControl.customResourceFinalizerRemoved(customResource);
            }
        }
        log.debug("Skipping finalizer remove for resource: {} with version: {}. delete control: {}, uses finalizer: {}", new Object[]{KubernetesResourceUtils.getUID(resource), KubernetesResourceUtils.getVersion(resource), deleteControl, useFinalizer});
        PostExecutionControl postExecutionControl = PostExecutionControl.defaultDispatch();
        this.updatePostExecutionControlWithReschedule(postExecutionControl, deleteControl);
        return postExecutionControl;
    }

    private P updateCustomResourceWithFinalizer(P resourceForExecution, P originalResource) {
        log.debug("Adding finalizer for resource: {} version: {}", (Object)KubernetesResourceUtils.getUID(originalResource), (Object)KubernetesResourceUtils.getVersion(originalResource));
        return (P)this.conflictRetryingUpdate(resourceForExecution, r -> r.addFinalizer(this.configuration().getFinalizerName()));
    }

    private P updateCustomResource(P resource) {
        log.debug("Updating resource: {} with version: {}", (Object)KubernetesResourceUtils.getUID(resource), (Object)KubernetesResourceUtils.getVersion(resource));
        log.trace("Resource before update: {}", resource);
        return this.customResourceFacade.updateResource(resource);
    }

    ControllerConfiguration<P> configuration() {
        return this.controller.getConfiguration();
    }

    public P conflictRetryingUpdate(P resource, Function<P, Boolean> modificationFunction) {
        if (log.isDebugEnabled()) {
            log.debug("Removing finalizer on resource: {}", (Object)ResourceID.fromResource(resource));
        }
        int retryIndex = 0;
        while (true) {
            try {
                Boolean modified = modificationFunction.apply(resource);
                if (Boolean.FALSE.equals(modified)) {
                    return resource;
                }
                return this.customResourceFacade.updateResource(resource);
            }
            catch (KubernetesClientException e) {
                log.trace("Exception during patch for resource: {}", resource);
                ++retryIndex;
                if (e.getCode() != 409) {
                    throw e;
                }
                if (retryIndex >= 10) {
                    throw new OperatorException("Exceeded maximum (10) retry attempts to patch resource: " + ResourceID.fromResource(resource));
                }
                resource = this.customResourceFacade.getResource(resource.getMetadata().getNamespace(), resource.getMetadata().getName());
                continue;
            }
            break;
        }
    }

    static class CustomResourceFacade<R extends HasMetadata> {
        private final MixedOperation<R, KubernetesResourceList<R>, Resource<R>> resourceOperation;

        public CustomResourceFacade(MixedOperation<R, KubernetesResourceList<R>, Resource<R>> resourceOperation) {
            this.resourceOperation = resourceOperation;
        }

        public R getResource(String namespace, String name) {
            if (namespace != null) {
                return (R)((HasMetadata)((Resource)((NonNamespaceOperation)this.resourceOperation.inNamespace(namespace)).withName(name)).get());
            }
            return (R)((HasMetadata)((Resource)this.resourceOperation.withName(name)).get());
        }

        public R updateResource(R resource) {
            log.debug("Trying to replace resource {}, version: {}", (Object)KubernetesResourceUtils.getName(resource), (Object)resource.getMetadata().getResourceVersion());
            return (R)((HasMetadata)this.resource(resource).lockResourceVersion(resource.getMetadata().getResourceVersion()).update());
        }

        public R updateStatus(R resource) {
            log.trace("Updating status for resource: {}", resource);
            return (R)((HasMetadata)this.resource(resource).lockResourceVersion().updateStatus());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R patchStatus(R resource, R originalResource) {
            log.trace("Updating status for resource: {}", resource);
            String resourceVersion = resource.getMetadata().getResourceVersion();
            originalResource.getMetadata().setResourceVersion(null);
            resource.getMetadata().setResourceVersion(null);
            try {
                HasMetadata hasMetadata = (HasMetadata)this.resource(originalResource).editStatus(r -> resource);
                return (R)hasMetadata;
            }
            finally {
                originalResource.getMetadata().setResourceVersion(resourceVersion);
                resource.getMetadata().setResourceVersion(resourceVersion);
            }
        }

        private Resource<R> resource(R resource) {
            return resource instanceof Namespaced ? (Resource)((NonNamespaceOperation)this.resourceOperation.inNamespace(resource.getMetadata().getNamespace())).resource(resource) : (Resource)this.resourceOperation.resource(resource);
        }
    }
}

