/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.fabric8.zjsonpatch.JsonDiff;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.Matcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GenericKubernetesResourceMatcher<R extends HasMetadata, P extends HasMetadata>
implements Matcher<R, P> {
    private static final String SPEC = "/spec";
    private static final String METADATA = "/metadata";
    private static final String ADD = "add";
    private static final String OP = "op";
    private static final List<String> IGNORED_FIELDS = List.of("/apiVersion", "/kind", "/status");
    public static final String METADATA_LABELS = "/metadata/labels";
    public static final String METADATA_ANNOTATIONS = "/metadata/annotations";
    private static final String PATH = "path";
    private static final String[] EMPTY_ARRAY = new String[0];
    private final KubernetesDependentResource<R, P> dependentResource;

    private GenericKubernetesResourceMatcher(KubernetesDependentResource<R, P> dependentResource) {
        this.dependentResource = dependentResource;
    }

    static <R extends HasMetadata, P extends HasMetadata> Matcher<R, P> matcherFor(KubernetesDependentResource<R, P> dependentResource) {
        return new GenericKubernetesResourceMatcher<R, P>(dependentResource);
    }

    @Override
    public Matcher.Result<R> match(R actualResource, P primary, Context<P> context) {
        R desired = this.dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, false, false, false, context);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(R desired, R actualResource, boolean considerLabelsAndAnnotations, boolean labelsAndAnnotationsEquality, boolean valuesEquality, Context<P> context) {
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, labelsAndAnnotationsEquality, valuesEquality, context, EMPTY_ARRAY);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(R desired, R actualResource, boolean considerLabelsAndAnnotations, boolean labelsAndAnnotationsEquality, Context<P> context, String ... ignorePaths) {
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, labelsAndAnnotationsEquality, false, context, ignorePaths);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(KubernetesDependentResource<R, P> dependentResource, R actualResource, P primary, Context<P> context, boolean considerLabelsAndAnnotations, boolean labelsAndAnnotationsEquality, String ... ignorePaths) {
        R desired = dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, labelsAndAnnotationsEquality, context, ignorePaths);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(KubernetesDependentResource<R, P> dependentResource, R actualResource, P primary, Context<P> context, boolean considerLabelsAndAnnotations, boolean labelsAndAnnotationsEquality, boolean specEquality) {
        R desired = dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, labelsAndAnnotationsEquality, specEquality, context);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(R desired, R actualResource, boolean considerMetadata, boolean labelsAndAnnotationsEquality, boolean valuesEquality, Context<P> context, String ... ignoredPaths) {
        List<String> ignoreList;
        List<String> list = ignoreList = ignoredPaths != null && ignoredPaths.length > 0 ? Arrays.asList(ignoredPaths) : Collections.emptyList();
        if (valuesEquality && !ignoreList.isEmpty()) {
            throw new IllegalArgumentException("Equality should be false in case of ignore list provided");
        }
        KubernetesSerialization kubernetesSerialization = context.getClient().getKubernetesSerialization();
        JsonNode desiredNode = (JsonNode)kubernetesSerialization.convertValue(desired, JsonNode.class);
        JsonNode actualNode = (JsonNode)kubernetesSerialization.convertValue(actualResource, JsonNode.class);
        JsonNode wholeDiffJsonPatch = JsonDiff.asJson((JsonNode)desiredNode, (JsonNode)actualNode);
        boolean matched = true;
        for (int i = 0; i < wholeDiffJsonPatch.size() && matched; ++i) {
            JsonNode node = wholeDiffJsonPatch.get(i);
            if (GenericKubernetesResourceMatcher.nodeIsChildOf(node, List.of(SPEC))) {
                matched = GenericKubernetesResourceMatcher.match(valuesEquality, node, ignoreList);
                continue;
            }
            if (GenericKubernetesResourceMatcher.nodeIsChildOf(node, List.of(METADATA))) {
                if (!considerMetadata || !GenericKubernetesResourceMatcher.nodeIsChildOf(node, List.of(METADATA_LABELS, METADATA_ANNOTATIONS))) continue;
                matched = GenericKubernetesResourceMatcher.match(labelsAndAnnotationsEquality, node, Collections.emptyList());
                continue;
            }
            if (GenericKubernetesResourceMatcher.nodeIsChildOf(node, IGNORED_FIELDS)) continue;
            matched = GenericKubernetesResourceMatcher.match(valuesEquality, node, ignoreList);
        }
        return Matcher.Result.computed(matched, desired);
    }

    private static boolean match(boolean equality, JsonNode diff, List<String> ignoreList) {
        if (equality) {
            return false;
        }
        if (!ignoreList.isEmpty()) {
            return GenericKubernetesResourceMatcher.nodeIsChildOf(diff, ignoreList);
        }
        return ADD.equals(diff.get(OP).asText());
    }

    static boolean nodeIsChildOf(JsonNode n, List<String> prefixes) {
        String path = GenericKubernetesResourceMatcher.getPath(n);
        return prefixes.stream().anyMatch(path::startsWith);
    }

    static String getPath(JsonNode n) {
        return n.get(PATH).asText();
    }

    @Deprecated(forRemoval=true)
    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(KubernetesDependentResource<R, P> dependentResource, R actualResource, P primary, Context<P> context, boolean considerLabelsAndAnnotations, boolean specEquality) {
        R desired = dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, specEquality, context, new String[0]);
    }

    @Deprecated(forRemoval=true)
    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(KubernetesDependentResource<R, P> dependentResource, R actualResource, P primary, Context<P> context, boolean considerLabelsAndAnnotations, String ... ignorePaths) {
        R desired = dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, true, context, ignorePaths);
    }
}

