/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.virtual.threads;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.virtual.threads.ContextPreservingExecutorService;
import io.quarkus.virtual.threads.VirtualThreadsConfig;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

@Recorder
public class VirtualThreadsRecorder {
    private static final Logger logger = Logger.getLogger((String)"io.quarkus.virtual-threads");
    static VirtualThreadsConfig config = new VirtualThreadsConfig();
    private static volatile Executor current;
    private static final Object lock;

    public void setupVirtualThreads(VirtualThreadsConfig c, ShutdownContext shutdownContext, LaunchMode launchMode) {
        config = c;
        if (launchMode == LaunchMode.DEVELOPMENT) {
            shutdownContext.addLastShutdownTask(new Runnable(){

                @Override
                public void run() {
                    Executor executor = current;
                    if (executor instanceof ExecutorService) {
                        ((ExecutorService)executor).shutdownNow();
                    }
                    current = null;
                }
            });
        } else {
            shutdownContext.addLastShutdownTask(new Runnable(){

                @Override
                public void run() {
                    Executor executor = current;
                    current = null;
                    if (executor instanceof ExecutorService) {
                        ExecutorService service = (ExecutorService)executor;
                        service.shutdown();
                        long timeout = VirtualThreadsRecorder.config.shutdownTimeout.toNanos();
                        long interval = VirtualThreadsRecorder.config.shutdownCheckInterval.orElse(VirtualThreadsRecorder.config.shutdownTimeout).toNanos();
                        long start = System.nanoTime();
                        int loop = 1;
                        long elapsed = 0L;
                        while (true) {
                            logger.debugf("Await termination loop: %s, remaining: %s", (long)loop++, timeout - elapsed);
                            try {
                                if (!service.awaitTermination(Math.min(timeout, interval), TimeUnit.NANOSECONDS)) {
                                    elapsed = System.nanoTime() - start;
                                    if (elapsed < timeout) continue;
                                } else {
                                    return;
                                }
                                service.shutdownNow();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor getCurrent() {
        Executor executor = current;
        if (executor != null) {
            return executor;
        }
        Object object = lock;
        synchronized (object) {
            if (current == null) {
                current = VirtualThreadsRecorder.createExecutor();
            }
            return current;
        }
    }

    static ExecutorService newVirtualThreadPerTaskExecutorWithName(String prefix) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Method ofVirtual = Thread.class.getMethod("ofVirtual", new Class[0]);
        Object vtb = ofVirtual.invoke(VirtualThreadsRecorder.class, new Object[0]);
        Class<?> vtbClass = Class.forName("java.lang.Thread$Builder$OfVirtual");
        Method name = vtbClass.getMethod("name", String.class, Long.TYPE);
        vtb = name.invoke(vtb, prefix, 0);
        Method factory = vtbClass.getMethod("factory", new Class[0]);
        ThreadFactory tf = (ThreadFactory)factory.invoke(vtb, new Object[0]);
        return (ExecutorService)Executors.class.getMethod("newThreadPerTaskExecutor", ThreadFactory.class).invoke(VirtualThreadsRecorder.class, tf);
    }

    static ExecutorService newVirtualThreadPerTaskExecutor() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (ExecutorService)Executors.class.getMethod("newVirtualThreadPerTaskExecutor", new Class[0]).invoke(VirtualThreadsRecorder.class, new Object[0]);
    }

    static ExecutorService newVirtualThreadExecutor() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        try {
            Optional<String> namePrefix = VirtualThreadsRecorder.config.namePrefix;
            return namePrefix.isPresent() ? VirtualThreadsRecorder.newVirtualThreadPerTaskExecutorWithName(namePrefix.get()) : VirtualThreadsRecorder.newVirtualThreadPerTaskExecutor();
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"Unable to invoke java.util.concurrent.Executors#newThreadPerTaskExecutor with VirtualThreadFactory, falling back to unnamed virtual threads", (Throwable)e);
            return VirtualThreadsRecorder.newVirtualThreadPerTaskExecutor();
        }
    }

    private static Executor createExecutor() {
        try {
            return new ContextPreservingExecutorService(VirtualThreadsRecorder.newVirtualThreadExecutor());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.debug((Object)"Unable to invoke java.util.concurrent.Executors#newVirtualThreadPerTaskExecutor", (Throwable)e);
            logger.warn((Object)"You weren't able to create an executor that spawns virtual threads, the default blocking executor will be used, please check that your JDK is compatible with virtual threads");
            return new Executor(){

                @Override
                public void execute(Runnable command) {
                    Context context = Vertx.currentContext();
                    if (!(context instanceof ContextInternal)) {
                        Infrastructure.getDefaultWorkerPool().execute(command);
                    } else {
                        context.executeBlocking(fut -> {
                            try {
                                command.run();
                                fut.complete(null);
                            }
                            catch (Exception e) {
                                fut.fail((Throwable)e);
                            }
                        }, false);
                    }
                }
            };
        }
    }

    static {
        lock = new Object();
    }
}

