/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.BackupConfig;
import io.fabric8.openshift.api.model.hive.v1.BackupConfigFluent;
import io.fabric8.openshift.api.model.hive.v1.VeleroBackupConfig;
import io.fabric8.openshift.api.model.hive.v1.VeleroBackupConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.VeleroBackupConfigFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class BackupConfigFluentImpl<A extends BackupConfigFluent<A>>
extends BaseFluent<A>
implements BackupConfigFluent<A> {
    private Integer minBackupPeriodSeconds;
    private VeleroBackupConfigBuilder velero;
    private Map<String, Object> additionalProperties;

    public BackupConfigFluentImpl() {
    }

    public BackupConfigFluentImpl(BackupConfig instance) {
        if (instance != null) {
            this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
            this.withVelero(instance.getVelero());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public Integer getMinBackupPeriodSeconds() {
        return this.minBackupPeriodSeconds;
    }

    @Override
    public A withMinBackupPeriodSeconds(Integer minBackupPeriodSeconds) {
        this.minBackupPeriodSeconds = minBackupPeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinBackupPeriodSeconds() {
        return this.minBackupPeriodSeconds != null;
    }

    @Override
    @Deprecated
    public VeleroBackupConfig getVelero() {
        return this.velero != null ? this.velero.build() : null;
    }

    @Override
    public VeleroBackupConfig buildVelero() {
        return this.velero != null ? this.velero.build() : null;
    }

    @Override
    public A withVelero(VeleroBackupConfig velero) {
        this._visitables.get((Object)"velero").remove(this.velero);
        if (velero != null) {
            this.velero = new VeleroBackupConfigBuilder(velero);
            this._visitables.get((Object)"velero").add(this.velero);
        } else {
            this.velero = null;
            this._visitables.get((Object)"velero").remove(this.velero);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVelero() {
        return this.velero != null;
    }

    @Override
    public A withNewVelero(Boolean enabled, String namespace) {
        return this.withVelero(new VeleroBackupConfig(enabled, namespace));
    }

    @Override
    public BackupConfigFluent.VeleroNested<A> withNewVelero() {
        return new VeleroNestedImpl();
    }

    @Override
    public BackupConfigFluent.VeleroNested<A> withNewVeleroLike(VeleroBackupConfig item) {
        return new VeleroNestedImpl(item);
    }

    @Override
    public BackupConfigFluent.VeleroNested<A> editVelero() {
        return this.withNewVeleroLike(this.getVelero());
    }

    @Override
    public BackupConfigFluent.VeleroNested<A> editOrNewVelero() {
        return this.withNewVeleroLike(this.getVelero() != null ? this.getVelero() : new VeleroBackupConfigBuilder().build());
    }

    @Override
    public BackupConfigFluent.VeleroNested<A> editOrNewVeleroLike(VeleroBackupConfig item) {
        return this.withNewVeleroLike(this.getVelero() != null ? this.getVelero() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackupConfigFluentImpl that = (BackupConfigFluentImpl)o;
        if (!Objects.equals(this.minBackupPeriodSeconds, that.minBackupPeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.velero, that.velero)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.minBackupPeriodSeconds, this.velero, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minBackupPeriodSeconds != null) {
            sb.append("minBackupPeriodSeconds:");
            sb.append(this.minBackupPeriodSeconds + ",");
        }
        if (this.velero != null) {
            sb.append("velero:");
            sb.append(this.velero + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class VeleroNestedImpl<N>
    extends VeleroBackupConfigFluentImpl<BackupConfigFluent.VeleroNested<N>>
    implements BackupConfigFluent.VeleroNested<N>,
    Nested<N> {
        VeleroBackupConfigBuilder builder;

        VeleroNestedImpl(VeleroBackupConfig item) {
            this.builder = new VeleroBackupConfigBuilder(this, item);
        }

        VeleroNestedImpl() {
            this.builder = new VeleroBackupConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)BackupConfigFluentImpl.this.withVelero(this.builder.build());
        }

        @Override
        public N endVelero() {
            return this.and();
        }
    }
}

