/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.docs;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class Processing {
    public static <A extends Annotation> boolean isAnnotated(Element element, Class<A> annotation) {
        return element.getAnnotation(annotation) != null;
    }

    public static <T extends Annotation> Optional<T> annotation(Element element, Class<T> annotation) {
        return Optional.ofNullable(element.getAnnotation(annotation));
    }

    public static Optional<DeclaredType> asDeclared(TypeMirror type) {
        return Optional.of(type).filter(t -> t instanceof DeclaredType).map(DeclaredType.class::cast);
    }

    public static Optional<Element> asElement(TypeMirror type) {
        return Processing.asDeclared(type).map(DeclaredType::asElement);
    }

    public static Optional<TypeElement> asEnum(TypeMirror type) {
        return Processing.asElement(type).filter(e -> e.getKind() == ElementKind.ENUM).map(TypeElement.class::cast);
    }

    public static <T extends Element> Stream<T> enclosedElements(Element element, ElementKind kind, Class<T> clazz) {
        return Processing.enclosedElements(element, kind).map(clazz::cast);
    }

    public static Stream<? extends Element> enclosedElements(Element element, ElementKind kind) {
        return Processing.enclosedElements(element).filter(e -> e.getKind() == kind);
    }

    public static Stream<? extends Element> enclosedElements(Element element) {
        return element.getEnclosedElements().stream();
    }

    public static Stream<? extends TypeMirror> typeArguments(DeclaredType type) {
        return type.getTypeArguments().stream();
    }

    public static <T> Stream<T> typeArguments(DeclaredType type, Function<TypeMirror, T> mapper) {
        return Processing.typeArguments(type).map(mapper);
    }

    private Processing() {
    }
}

