/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ManagedFieldsEntry;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.LoggingUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSABasedGenericKubernetesResourceMatcher<R extends HasMetadata> {
    private static final SSABasedGenericKubernetesResourceMatcher INSTANCE = new SSABasedGenericKubernetesResourceMatcher();
    public static final String APPLY_OPERATION = "Apply";
    public static final String DOT_KEY = ".";
    private static final String F_PREFIX = "f:";
    private static final String K_PREFIX = "k:";
    private static final String V_PREFIX = "v:";
    private static final String METADATA_KEY = "metadata";
    private static final String NAME_KEY = "name";
    private static final String NAMESPACE_KEY = "namespace";
    private static final String KIND_KEY = "kind";
    private static final String API_VERSION_KEY = "apiVersion";
    private static final Logger log = LoggerFactory.getLogger(SSABasedGenericKubernetesResourceMatcher.class);

    public static <L extends HasMetadata> SSABasedGenericKubernetesResourceMatcher<L> getInstance() {
        return INSTANCE;
    }

    public boolean matches(R actual, R desired, Context<?> context) {
        Optional<ManagedFieldsEntry> optionalManagedFieldsEntry = this.checkIfFieldManagerExists(actual, context.getControllerConfiguration().fieldManager());
        if (optionalManagedFieldsEntry.isEmpty()) {
            return false;
        }
        ManagedFieldsEntry managedFieldsEntry = optionalManagedFieldsEntry.orElseThrow();
        KubernetesSerialization objectMapper = context.getClient().getKubernetesSerialization();
        Map actualMap = (Map)objectMapper.convertValue(actual, Map.class);
        Map desiredMap = (Map)objectMapper.convertValue(desired, Map.class);
        if (LoggingUtils.isNotSensitiveResource(desired)) {
            log.trace("Original actual: \n {} \n original desired: \n {} ", actual, (Object)desiredMap);
        }
        HashMap<String, Object> prunedActual = new HashMap<String, Object>(actualMap.size());
        SSABasedGenericKubernetesResourceMatcher.keepOnlyManagedFields(prunedActual, actualMap, managedFieldsEntry.getFieldsV1().getAdditionalProperties(), objectMapper);
        SSABasedGenericKubernetesResourceMatcher.removeIrrelevantValues(desiredMap);
        if (LoggingUtils.isNotSensitiveResource(desired)) {
            log.debug("Pruned actual: \n {} \n desired: \n {} ", prunedActual, (Object)desiredMap);
        }
        return prunedActual.equals(desiredMap);
    }

    private static void removeIrrelevantValues(Map<String, Object> desiredMap) {
        Map metadata = (Map)desiredMap.get(METADATA_KEY);
        metadata.remove(NAME_KEY);
        metadata.remove(NAMESPACE_KEY);
        if (metadata.isEmpty()) {
            desiredMap.remove(METADATA_KEY);
        }
        desiredMap.remove(KIND_KEY);
        desiredMap.remove(API_VERSION_KEY);
    }

    private static void keepOnlyManagedFields(Map<String, Object> result, Map<String, Object> actualMap, Map<String, Object> managedFields, KubernetesSerialization objectMapper) {
        if (managedFields.isEmpty()) {
            result.putAll(actualMap);
            return;
        }
        for (Map.Entry<String, Object> entry : managedFields.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith(F_PREFIX)) {
                String keyInActual = SSABasedGenericKubernetesResourceMatcher.keyWithoutPrefix(key);
                Map managedFieldValue = (Map)entry.getValue();
                if (SSABasedGenericKubernetesResourceMatcher.isNestedValue(managedFieldValue)) {
                    Set<Map.Entry<String, Object>> managedEntrySet = managedFieldValue.entrySet();
                    if (SSABasedGenericKubernetesResourceMatcher.isListKeyEntrySet(managedEntrySet)) {
                        SSABasedGenericKubernetesResourceMatcher.handleListKeyEntrySet(result, actualMap, objectMapper, keyInActual, managedEntrySet);
                        continue;
                    }
                    if (SSABasedGenericKubernetesResourceMatcher.isSetValueField(managedEntrySet)) {
                        SSABasedGenericKubernetesResourceMatcher.handleSetValues(result, actualMap, objectMapper, keyInActual, managedEntrySet);
                        continue;
                    }
                    SSABasedGenericKubernetesResourceMatcher.fillResultsAndTraverseFurther(result, actualMap, managedFields, objectMapper, key, keyInActual, managedFieldValue);
                    continue;
                }
                result.put(keyInActual, actualMap.get(keyInActual));
                continue;
            }
            if (DOT_KEY.equals(key)) continue;
            throw new IllegalStateException("Key: " + key + " has no prefix: f:");
        }
    }

    private static void fillResultsAndTraverseFurther(Map<String, Object> result, Map<String, Object> actualMap, Map<String, Object> managedFields, KubernetesSerialization objectMapper, String key, String keyInActual, Object managedFieldValue) {
        HashMap<String, Object> emptyMapValue = new HashMap<String, Object>();
        result.put(keyInActual, emptyMapValue);
        Object actualMapValue = actualMap.get(keyInActual);
        log.debug("key: {} actual map value: {} managedFieldValue: {}", new Object[]{keyInActual, actualMapValue, managedFieldValue});
        SSABasedGenericKubernetesResourceMatcher.keepOnlyManagedFields(emptyMapValue, (Map)actualMapValue, (Map)managedFields.get(key), objectMapper);
    }

    private static boolean isNestedValue(Map<?, ?> managedFieldValue) {
        return !managedFieldValue.isEmpty();
    }

    private static void handleListKeyEntrySet(Map<String, Object> result, Map<String, Object> actualMap, KubernetesSerialization objectMapper, String keyInActual, Set<Map.Entry<String, Object>> managedEntrySet) {
        ArrayList valueList = new ArrayList();
        result.put(keyInActual, valueList);
        List actualValueList = (List)actualMap.get(keyInActual);
        TreeMap<Integer, Map> targetValuesByIndex = new TreeMap<Integer, Map>();
        HashMap<Integer, Map> managedEntryByIndex = new HashMap<Integer, Map>();
        for (Map.Entry<String, Object> listEntry : managedEntrySet) {
            if (DOT_KEY.equals(listEntry.getKey())) continue;
            Map.Entry<Integer, Map<String, Object>> actualListEntry = SSABasedGenericKubernetesResourceMatcher.selectListEntryBasedOnKey(SSABasedGenericKubernetesResourceMatcher.keyWithoutPrefix(listEntry.getKey()), actualValueList, objectMapper);
            targetValuesByIndex.put(actualListEntry.getKey(), actualListEntry.getValue());
            managedEntryByIndex.put(actualListEntry.getKey(), (Map)listEntry.getValue());
        }
        targetValuesByIndex.forEach((key, value) -> {
            HashMap<String, Object> emptyResMapValue = new HashMap<String, Object>();
            valueList.add(emptyResMapValue);
            SSABasedGenericKubernetesResourceMatcher.keepOnlyManagedFields(emptyResMapValue, value, (Map)managedEntryByIndex.get(key), objectMapper);
        });
    }

    private static void handleSetValues(Map<String, Object> result, Map<String, Object> actualMap, KubernetesSerialization objectMapper, String keyInActual, Set<Map.Entry<String, Object>> managedEntrySet) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        result.put(keyInActual, valueList);
        for (Map.Entry<String, Object> valueEntry : managedEntrySet) {
            if (DOT_KEY.equals(valueEntry.getKey())) continue;
            Class<?> targetClass = null;
            List values = (List)actualMap.get(keyInActual);
            if (!(values.get(0) instanceof Map)) {
                targetClass = values.get(0).getClass();
            }
            Object value = SSABasedGenericKubernetesResourceMatcher.parseKeyValue(SSABasedGenericKubernetesResourceMatcher.keyWithoutPrefix(valueEntry.getKey()), targetClass, objectMapper);
            valueList.add(value);
        }
    }

    public static Object parseKeyValue(String stringValue, Class<?> targetClass, KubernetesSerialization objectMapper) {
        stringValue = stringValue.trim();
        if (targetClass != null) {
            return objectMapper.unmarshal(stringValue, targetClass);
        }
        return objectMapper.unmarshal(stringValue, Map.class);
    }

    private static boolean isSetValueField(Set<Map.Entry<String, Object>> managedEntrySet) {
        return SSABasedGenericKubernetesResourceMatcher.isKeyPrefixedSkippingDotKey(managedEntrySet, V_PREFIX);
    }

    private static boolean isListKeyEntrySet(Set<Map.Entry<String, Object>> managedEntrySet) {
        return SSABasedGenericKubernetesResourceMatcher.isKeyPrefixedSkippingDotKey(managedEntrySet, K_PREFIX);
    }

    private static boolean isKeyPrefixedSkippingDotKey(Set<Map.Entry<String, Object>> managedEntrySet, String prefix) {
        Iterator<Map.Entry<String, Object>> iterator = managedEntrySet.iterator();
        Map.Entry<String, Object> managedFieldEntry = iterator.next();
        if (managedFieldEntry.getKey().equals(DOT_KEY)) {
            managedFieldEntry = iterator.next();
        }
        return managedFieldEntry.getKey().startsWith(prefix);
    }

    private static Map.Entry<Integer, Map<String, Object>> selectListEntryBasedOnKey(String key, List<Map<String, Object>> values, KubernetesSerialization objectMapper) {
        Map ids = (Map)objectMapper.unmarshal(key, Map.class);
        final ArrayList<Map<String, Object>> possibleTargets = new ArrayList<Map<String, Object>>(1);
        int index = -1;
        for (int i = 0; i < values.size(); ++i) {
            Map<String, Object> v = values.get(i);
            if (!v.entrySet().containsAll(ids.entrySet())) continue;
            possibleTargets.add(v);
            index = i;
        }
        if (possibleTargets.isEmpty()) {
            throw new IllegalStateException("Cannot find list element for key:" + key + ", in map: " + values);
        }
        if (possibleTargets.size() > 1) {
            throw new IllegalStateException("More targets found in list element for key:" + key + ", in map: " + values);
        }
        final int finalIndex = index;
        return new Map.Entry<Integer, Map<String, Object>>(){

            @Override
            public Integer getKey() {
                return finalIndex;
            }

            @Override
            public Map<String, Object> getValue() {
                return (Map)possibleTargets.get(0);
            }

            @Override
            public Map<String, Object> setValue(Map<String, Object> stringObjectMap) {
                throw new IllegalStateException("should not be called");
            }
        };
    }

    private Optional<ManagedFieldsEntry> checkIfFieldManagerExists(R actual, String fieldManager) {
        List targetManagedFields = actual.getMetadata().getManagedFields().stream().filter(f -> f.getManager().equals(fieldManager) && f.getOperation().equals(APPLY_OPERATION)).collect(Collectors.toList());
        if (targetManagedFields.isEmpty()) {
            log.debug("No field manager exists for resource {} with name: {} and operation Apply ", actual, (Object)actual.getMetadata().getName());
            return Optional.empty();
        }
        if (targetManagedFields.size() > 1) {
            throw new OperatorException("More than one field manager exists with name: " + fieldManager + "in resource: " + actual + " with name: " + actual.getMetadata().getName());
        }
        return Optional.of((ManagedFieldsEntry)targetManagedFields.get(0));
    }

    private static String keyWithoutPrefix(String key) {
        return key.substring(2);
    }
}

