/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnDeleteFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import java.util.Set;

public class KubernetesDependentResourceConfig<R> {
    private Set<String> namespaces;
    private String labelSelector;
    private boolean namespacesWereConfigured;
    private ResourceDiscriminator<R, ?> resourceDiscriminator;
    private final OnAddFilter<R> onAddFilter;
    private final OnUpdateFilter<R> onUpdateFilter;
    private final OnDeleteFilter<R> onDeleteFilter;
    private final GenericFilter<R> genericFilter;

    public KubernetesDependentResourceConfig() {
        this(Constants.SAME_AS_CONTROLLER_NAMESPACES_SET, "", true, null, null, null, null, null);
    }

    public KubernetesDependentResourceConfig(Set<String> namespaces, String labelSelector, boolean configuredNS, ResourceDiscriminator<R, ?> resourceDiscriminator, OnAddFilter<R> onAddFilter, OnUpdateFilter<R> onUpdateFilter, OnDeleteFilter<R> onDeleteFilter, GenericFilter<R> genericFilter) {
        this.namespaces = namespaces;
        this.labelSelector = labelSelector;
        this.namespacesWereConfigured = configuredNS;
        this.onAddFilter = onAddFilter;
        this.onUpdateFilter = onUpdateFilter;
        this.onDeleteFilter = onDeleteFilter;
        this.genericFilter = genericFilter;
        this.resourceDiscriminator = resourceDiscriminator;
    }

    @Deprecated(forRemoval=true)
    public KubernetesDependentResourceConfig(Set<String> namespaces, String labelSelector) {
        this(namespaces, labelSelector, true, null, null, null, null, null);
    }

    @Deprecated(forRemoval=true)
    public KubernetesDependentResourceConfig<R> setLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    public Set<String> namespaces() {
        return this.namespaces;
    }

    public String labelSelector() {
        return this.labelSelector;
    }

    public boolean wereNamespacesConfigured() {
        return this.namespacesWereConfigured;
    }

    public OnAddFilter onAddFilter() {
        return this.onAddFilter;
    }

    public OnUpdateFilter<R> onUpdateFilter() {
        return this.onUpdateFilter;
    }

    public OnDeleteFilter<R> onDeleteFilter() {
        return this.onDeleteFilter;
    }

    public GenericFilter<R> genericFilter() {
        return this.genericFilter;
    }

    public ResourceDiscriminator getResourceDiscriminator() {
        return this.resourceDiscriminator;
    }

    protected void setNamespaces(Set<String> namespaces) {
        if (!this.wereNamespacesConfigured() && namespaces != null && !namespaces.isEmpty()) {
            this.namespaces = namespaces;
        }
    }
}

