/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import org.slf4j.MDC;

public class MDCUtils {
    private static final String NAME = "resource.name";
    private static final String NAMESPACE = "resource.namespace";
    private static final String API_VERSION = "resource.apiVersion";
    private static final String KIND = "resource.kind";
    private static final String RESOURCE_VERSION = "resource.resourceVersion";
    private static final String GENERATION = "resource.generation";
    private static final String UID = "resource.uid";
    private static final String NO_NAMESPACE = "no namespace";

    public static void addResourceIDInfo(ResourceID resourceID) {
        MDC.put((String)NAME, (String)resourceID.getName());
        MDC.put((String)NAMESPACE, (String)resourceID.getNamespace().orElse(NO_NAMESPACE));
    }

    public static void removeResourceIDInfo() {
        MDC.remove((String)NAME);
        MDC.remove((String)NAMESPACE);
    }

    public static void addResourceInfo(HasMetadata resource) {
        MDC.put((String)API_VERSION, (String)resource.getApiVersion());
        MDC.put((String)KIND, (String)resource.getKind());
        MDC.put((String)NAME, (String)resource.getMetadata().getName());
        if (resource.getMetadata().getNamespace() != null) {
            MDC.put((String)NAMESPACE, (String)resource.getMetadata().getNamespace());
        }
        MDC.put((String)RESOURCE_VERSION, (String)resource.getMetadata().getResourceVersion());
        if (resource.getMetadata().getGeneration() != null) {
            MDC.put((String)GENERATION, (String)resource.getMetadata().getGeneration().toString());
        }
        MDC.put((String)UID, (String)resource.getMetadata().getUid());
    }

    public static void removeResourceInfo() {
        MDC.remove((String)API_VERSION);
        MDC.remove((String)KIND);
        MDC.remove((String)NAME);
        MDC.remove((String)NAMESPACE);
        MDC.remove((String)RESOURCE_VERSION);
        MDC.remove((String)GENERATION);
        MDC.remove((String)UID);
    }
}

