/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.functions;

import io.sundr.model.ClassRef;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeRef;
import io.sundr.model.functions.Assignable;
import io.sundr.model.functions.GetDefinition;

public class ClassAssignable {
    private final ClassRef t;

    public ClassAssignable(ClassRef t) {
        this.t = t;
    }

    public Boolean from(TypeRef other) {
        if (this.t == other || this.t.equals((Object)other)) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof PrimitiveRef) {
            TypeDef definition = GetDefinition.of(this.t);
            if (definition == null) {
                return false;
            }
            if (definition != null && !"java.lang".equals(definition.getPackageName())) {
                return false;
            }
            if (!this.t.getName().toUpperCase().startsWith(((PrimitiveRef)other).getName().toUpperCase())) {
                return false;
            }
            return true;
        }
        if (!(other instanceof ClassRef)) {
            return false;
        }
        ClassRef otherClassRef = (ClassRef)other;
        if (otherClassRef.getFullyQualifiedName().equals(this.t.getFullyQualifiedName())) {
            return true;
        }
        TypeDef definition = GetDefinition.of(this.t);
        TypeDef otherDefinition = GetDefinition.of(otherClassRef);
        return Assignable.isAssignable(definition).from(otherDefinition);
    }
}

