/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.PolicyMappingConfig;
import io.quarkus.vertx.http.runtime.security.DenySecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PathMatcher;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class AbstractPathMatchingHttpSecurityPolicy {
    private final PathMatcher<List<HttpMatcher>> pathMatcher = new PathMatcher();

    public String getAuthMechanismName(RoutingContext routingContext) {
        PathMatcher.PathMatch<List<HttpMatcher>> toCheck = this.pathMatcher.match(routingContext.normalizedPath());
        if (toCheck.getValue() == null || toCheck.getValue().isEmpty()) {
            return null;
        }
        for (HttpMatcher i : toCheck.getValue()) {
            if (i.authMechanism == null) continue;
            return i.authMechanism;
        }
        return null;
    }

    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext routingContext, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        List<HttpSecurityPolicy> permissionCheckers = this.findPermissionCheckers(routingContext);
        return this.doPermissionCheck(routingContext, identity, 0, null, permissionCheckers, requestContext);
    }

    private Uni<HttpSecurityPolicy.CheckResult> doPermissionCheck(final RoutingContext routingContext, final Uni<SecurityIdentity> identity, final int index, final SecurityIdentity augmentedIdentity, final List<HttpSecurityPolicy> permissionCheckers, final HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        if (index == permissionCheckers.size()) {
            return Uni.createFrom().item((Object)new HttpSecurityPolicy.CheckResult(true, augmentedIdentity));
        }
        HttpSecurityPolicy res = permissionCheckers.get(index);
        return res.checkPermission(routingContext, identity, requestContext).flatMap((Function)new Function<HttpSecurityPolicy.CheckResult, Uni<? extends HttpSecurityPolicy.CheckResult>>(){

            @Override
            public Uni<? extends HttpSecurityPolicy.CheckResult> apply(HttpSecurityPolicy.CheckResult checkResult) {
                if (!checkResult.isPermitted()) {
                    return Uni.createFrom().item((Object)HttpSecurityPolicy.CheckResult.DENY);
                }
                if (checkResult.getAugmentedIdentity() != null) {
                    return AbstractPathMatchingHttpSecurityPolicy.this.doPermissionCheck(routingContext, (Uni<SecurityIdentity>)Uni.createFrom().item((Object)checkResult.getAugmentedIdentity()), index + 1, checkResult.getAugmentedIdentity(), permissionCheckers, requestContext);
                }
                return AbstractPathMatchingHttpSecurityPolicy.this.doPermissionCheck(routingContext, (Uni<SecurityIdentity>)identity, index + 1, augmentedIdentity, permissionCheckers, requestContext);
            }
        });
    }

    public void init(Map<String, PolicyMappingConfig> permissions, Map<String, Supplier<HttpSecurityPolicy>> supplierMap, String rootPath) {
        HashMap<String, HttpSecurityPolicy> permissionCheckers = new HashMap<String, HttpSecurityPolicy>();
        for (Map.Entry<String, Supplier<HttpSecurityPolicy>> i : supplierMap.entrySet()) {
            permissionCheckers.put(i.getKey(), i.getValue().get());
        }
        HashMap tempMap = new HashMap();
        for (Map.Entry<String, PolicyMappingConfig> entry : permissions.entrySet()) {
            HttpSecurityPolicy checker = (HttpSecurityPolicy)permissionCheckers.get(entry.getValue().policy);
            if (checker == null) {
                throw new RuntimeException("Unable to find HTTP security policy " + entry.getValue().policy);
            }
            if (!entry.getValue().enabled.orElse(Boolean.TRUE).booleanValue()) continue;
            for (Object path : entry.getValue().paths.orElse(Collections.emptyList())) {
                HttpMatcher m;
                if (!((String)(path = ((String)path).trim())).startsWith("/")) {
                    path = rootPath + (String)path;
                }
                if (tempMap.containsKey(path)) {
                    m = new HttpMatcher(entry.getValue().authMechanism.orElse(null), new HashSet<String>(entry.getValue().methods.orElse(Collections.emptyList())), checker);
                    ((List)tempMap.get(path)).add(m);
                    continue;
                }
                m = new HttpMatcher(entry.getValue().authMechanism.orElse(null), new HashSet<String>(entry.getValue().methods.orElse(Collections.emptyList())), checker);
                ArrayList<HttpMatcher> perms = new ArrayList<HttpMatcher>();
                tempMap.put(path, perms);
                perms.add(m);
                if (((String)path).endsWith("/*")) {
                    String stripped = ((String)path).substring(0, ((String)path).length() - 2);
                    this.pathMatcher.addPrefixPath(stripped.isEmpty() ? "/" : stripped, perms);
                    continue;
                }
                if (((String)path).endsWith("*")) {
                    this.pathMatcher.addPrefixPath(((String)path).substring(0, ((String)path).length() - 1), perms);
                    continue;
                }
                this.pathMatcher.addExactPath((String)path, perms);
            }
        }
    }

    public List<HttpSecurityPolicy> findPermissionCheckers(RoutingContext context) {
        PathMatcher.PathMatch<List<HttpMatcher>> toCheck = this.pathMatcher.match(context.normalizedPath());
        if (toCheck.getValue() == null || toCheck.getValue().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HttpSecurityPolicy> methodMatch = new ArrayList<HttpSecurityPolicy>();
        ArrayList<HttpSecurityPolicy> noMethod = new ArrayList<HttpSecurityPolicy>();
        for (HttpMatcher i : toCheck.getValue()) {
            if (i.methods == null || i.methods.isEmpty()) {
                noMethod.add(i.checker);
                continue;
            }
            if (!i.methods.contains(context.request().method().toString())) continue;
            methodMatch.add(i.checker);
        }
        if (!methodMatch.isEmpty()) {
            return methodMatch;
        }
        if (!noMethod.isEmpty()) {
            return noMethod;
        }
        return Collections.singletonList(DenySecurityPolicy.INSTANCE);
    }

    static class HttpMatcher {
        final String authMechanism;
        final Set<String> methods;
        final HttpSecurityPolicy checker;

        HttpMatcher(String authMechanism, Set<String> methods, HttpSecurityPolicy checker) {
            this.methods = methods;
            this.checker = checker;
            this.authMechanism = authMechanism;
        }
    }
}

