/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.config.dependent.ConfigurationConverter;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnDeleteFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import java.util.Arrays;
import java.util.Set;

public class KubernetesDependentConverter<R extends HasMetadata, P extends HasMetadata>
implements ConfigurationConverter<KubernetesDependent, KubernetesDependentResourceConfig<R>, KubernetesDependentResource<R, P>> {
    @Override
    public KubernetesDependentResourceConfig<R> configFrom(KubernetesDependent configAnnotation, ControllerConfiguration<?> parentConfiguration, Class<KubernetesDependentResource<R, P>> originatingClass) {
        Set<String> namespaces = parentConfiguration.getNamespaces();
        boolean configuredNS = false;
        String labelSelector = null;
        OnAddFilter onAddFilter = null;
        OnUpdateFilter onUpdateFilter = null;
        OnDeleteFilter onDeleteFilter = null;
        GenericFilter genericFilter = null;
        ResourceDiscriminator resourceDiscriminator = null;
        if (configAnnotation != null) {
            String fromAnnotation;
            if (!Arrays.equals(KubernetesDependent.DEFAULT_NAMESPACES, configAnnotation.namespaces())) {
                namespaces = Set.of(configAnnotation.namespaces());
                configuredNS = true;
            }
            labelSelector = "".equals(fromAnnotation = configAnnotation.labelSelector()) ? null : fromAnnotation;
            String context = Utils.contextFor(parentConfiguration, originatingClass, configAnnotation.annotationType());
            onAddFilter = Utils.instantiate(configAnnotation.onAddFilter(), OnAddFilter.class, context);
            onUpdateFilter = Utils.instantiate(configAnnotation.onUpdateFilter(), OnUpdateFilter.class, context);
            onDeleteFilter = Utils.instantiate(configAnnotation.onDeleteFilter(), OnDeleteFilter.class, context);
            genericFilter = Utils.instantiate(configAnnotation.genericFilter(), GenericFilter.class, context);
            resourceDiscriminator = Utils.instantiate(configAnnotation.resourceDiscriminator(), ResourceDiscriminator.class, context);
        }
        return new KubernetesDependentResourceConfig(namespaces, labelSelector, configuredNS, resourceDiscriminator, onAddFilter, onUpdateFilter, onDeleteFilter, genericFilter);
    }
}

