/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import java.time.Duration;
import java.util.Optional;

public class LeaderElectionConfiguration {
    public static final Duration LEASE_DURATION_DEFAULT_VALUE = Duration.ofSeconds(15L);
    public static final Duration RENEW_DEADLINE_DEFAULT_VALUE = Duration.ofSeconds(10L);
    public static final Duration RETRY_PERIOD_DEFAULT_VALUE = Duration.ofSeconds(2L);
    private final String leaseName;
    private final String leaseNamespace;
    private final String identity;
    private final Duration leaseDuration;
    private final Duration renewDeadline;
    private final Duration retryPeriod;

    public LeaderElectionConfiguration(String leaseName, String leaseNamespace, String identity) {
        this(leaseName, leaseNamespace, LEASE_DURATION_DEFAULT_VALUE, RENEW_DEADLINE_DEFAULT_VALUE, RETRY_PERIOD_DEFAULT_VALUE, identity);
    }

    public LeaderElectionConfiguration(String leaseName, String leaseNamespace) {
        this(leaseName, leaseNamespace, LEASE_DURATION_DEFAULT_VALUE, RENEW_DEADLINE_DEFAULT_VALUE, RETRY_PERIOD_DEFAULT_VALUE, null);
    }

    public LeaderElectionConfiguration(String leaseName) {
        this(leaseName, null, LEASE_DURATION_DEFAULT_VALUE, RENEW_DEADLINE_DEFAULT_VALUE, RETRY_PERIOD_DEFAULT_VALUE, null);
    }

    public LeaderElectionConfiguration(String leaseName, String leaseNamespace, Duration leaseDuration, Duration renewDeadline, Duration retryPeriod) {
        this(leaseName, leaseNamespace, leaseDuration, renewDeadline, retryPeriod, null);
    }

    public LeaderElectionConfiguration(String leaseName, String leaseNamespace, Duration leaseDuration, Duration renewDeadline, Duration retryPeriod, String identity) {
        this.leaseName = leaseName;
        this.leaseNamespace = leaseNamespace;
        this.leaseDuration = leaseDuration;
        this.renewDeadline = renewDeadline;
        this.retryPeriod = retryPeriod;
        this.identity = identity;
    }

    public Optional<String> getLeaseNamespace() {
        return Optional.ofNullable(this.leaseNamespace);
    }

    public String getLeaseName() {
        return this.leaseName;
    }

    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    public Duration getRenewDeadline() {
        return this.renewDeadline;
    }

    public Duration getRetryPeriod() {
        return this.retryPeriod;
    }

    public Optional<String> getIdentity() {
        return Optional.ofNullable(this.identity);
    }
}

