/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ResolvedControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ControllerConfigurationOverrider<R extends HasMetadata> {
    private String finalizer;
    private boolean generationAware;
    private Set<String> namespaces;
    private Retry retry;
    private String labelSelector;
    private ResourceEventFilter<R> customResourcePredicate;
    private final ControllerConfiguration<R> original;
    private Duration reconciliationMaxInterval;
    private OnAddFilter<? super R> onAddFilter;
    private OnUpdateFilter<? super R> onUpdateFilter;
    private GenericFilter<? super R> genericFilter;
    private RateLimiter rateLimiter;
    private Map<DependentResourceSpec, Object> configurations;
    private ItemStore<R> itemStore;
    private String name;
    private String fieldManager;
    private Long informerListLimit;

    private ControllerConfigurationOverrider(ControllerConfiguration<R> original) {
        this.finalizer = original.getFinalizerName();
        this.generationAware = original.isGenerationAware();
        this.namespaces = new HashSet<String>(original.getNamespaces());
        this.retry = original.getRetry();
        this.labelSelector = original.getLabelSelector();
        this.customResourcePredicate = original.getEventFilter();
        this.reconciliationMaxInterval = original.maxReconciliationInterval().orElse(null);
        this.onAddFilter = original.onAddFilter().orElse(null);
        this.onUpdateFilter = original.onUpdateFilter().orElse(null);
        this.genericFilter = original.genericFilter().orElse(null);
        this.original = original;
        this.rateLimiter = original.getRateLimiter();
        this.name = original.getName();
        this.fieldManager = original.fieldManager();
        this.informerListLimit = original.getInformerListLimit().orElse(null);
    }

    public ControllerConfigurationOverrider<R> withFinalizer(String finalizer) {
        this.finalizer = finalizer;
        return this;
    }

    public ControllerConfigurationOverrider<R> withGenerationAware(boolean generationAware) {
        this.generationAware = generationAware;
        return this;
    }

    public ControllerConfigurationOverrider<R> watchingOnlyCurrentNamespace() {
        this.namespaces = Constants.WATCH_CURRENT_NAMESPACE_SET;
        return this;
    }

    public ControllerConfigurationOverrider<R> addingNamespaces(String ... namespaces) {
        this.namespaces.addAll(List.of(namespaces));
        return this;
    }

    public ControllerConfigurationOverrider<R> removingNamespaces(String ... namespaces) {
        List.of(namespaces).forEach(this.namespaces::remove);
        if (this.namespaces.isEmpty()) {
            this.namespaces = Constants.DEFAULT_NAMESPACES_SET;
        }
        return this;
    }

    public ControllerConfigurationOverrider<R> settingNamespaces(Set<String> newNamespaces) {
        this.namespaces.clear();
        this.namespaces.addAll(newNamespaces);
        return this;
    }

    public ControllerConfigurationOverrider<R> settingNamespaces(String ... newNamespaces) {
        return this.settingNamespaces(Set.of(newNamespaces));
    }

    public ControllerConfigurationOverrider<R> settingNamespace(String namespace) {
        this.namespaces.clear();
        this.namespaces.add(namespace);
        return this;
    }

    public ControllerConfigurationOverrider<R> watchingAllNamespaces() {
        this.namespaces = Constants.DEFAULT_NAMESPACES_SET;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ControllerConfigurationOverrider<R> withRetry(RetryConfiguration retry) {
        this.retry = GenericRetry.fromConfiguration(retry);
        return this;
    }

    public ControllerConfigurationOverrider<R> withRetry(Retry retry) {
        this.retry = retry;
        return this;
    }

    public ControllerConfigurationOverrider<R> withRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    public ControllerConfigurationOverrider<R> withLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    public ControllerConfigurationOverrider<R> withCustomResourcePredicate(ResourceEventFilter<R> customResourcePredicate) {
        this.customResourcePredicate = customResourcePredicate;
        return this;
    }

    public ControllerConfigurationOverrider<R> withReconciliationMaxInterval(Duration reconciliationMaxInterval) {
        this.reconciliationMaxInterval = reconciliationMaxInterval;
        return this;
    }

    public ControllerConfigurationOverrider<R> withOnAddFilter(OnAddFilter<R> onAddFilter) {
        this.onAddFilter = onAddFilter;
        return this;
    }

    public ControllerConfigurationOverrider<R> withOnUpdateFilter(OnUpdateFilter<R> onUpdateFilter) {
        this.onUpdateFilter = onUpdateFilter;
        return this;
    }

    public ControllerConfigurationOverrider<R> withGenericFilter(GenericFilter<R> genericFilter) {
        this.genericFilter = genericFilter;
        return this;
    }

    public ControllerConfigurationOverrider<R> withItemStore(ItemStore<R> itemStore) {
        this.itemStore = itemStore;
        return this;
    }

    public ControllerConfigurationOverrider<R> withName(String name) {
        this.name = name;
        return this;
    }

    public ControllerConfigurationOverrider<R> withFieldManager(String dependentFieldManager) {
        this.fieldManager = dependentFieldManager;
        return this;
    }

    public ControllerConfigurationOverrider<R> withInformerListLimit(Long informerListLimit) {
        this.informerListLimit = informerListLimit;
        return this;
    }

    public ControllerConfigurationOverrider<R> replacingNamedDependentResourceConfig(String name, Object dependentResourceConfig) {
        List<DependentResourceSpec> specs = this.original.getDependentResources();
        DependentResourceSpec spec = specs.stream().filter(drs -> drs.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find a DependentResource named: " + name));
        if (this.configurations == null) {
            this.configurations = new HashMap<DependentResourceSpec, Object>(specs.size());
        }
        this.configurations.put(spec, dependentResourceConfig);
        return this;
    }

    public ControllerConfiguration<R> build() {
        ResolvedControllerConfiguration<R> overridden = new ResolvedControllerConfiguration<R>(this.original.getResourceClass(), this.name, this.generationAware, this.original.getAssociatedReconcilerClassName(), this.retry, this.rateLimiter, this.reconciliationMaxInterval, this.onAddFilter, this.onUpdateFilter, this.genericFilter, this.original.getDependentResources(), this.namespaces, this.finalizer, this.labelSelector, this.configurations, this.itemStore, this.fieldManager, this.original.getConfigurationService(), this.informerListLimit);
        overridden.setEventFilter(this.customResourcePredicate);
        return overridden;
    }

    public static <R extends HasMetadata> ControllerConfigurationOverrider<R> override(ControllerConfiguration<R> original) {
        return new ControllerConfigurationOverrider<R>(original);
    }
}

