/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.functions;

import io.sundr.model.ClassRef;
import io.sundr.model.TypeDef;
import io.sundr.model.functions.GetDefinition;
import java.util.HashSet;

public class TypeAssignable {
    private final TypeDef t;

    public TypeAssignable(TypeDef t) {
        this.t = t;
    }

    public Boolean from(TypeDef other) {
        return this.from(other, new HashSet<String>());
    }

    public Boolean from(TypeDef other, HashSet<String> visited) {
        if (other.getFullyQualifiedName().equals("java.lang.Object")) {
            return false;
        }
        if (this.t == other || this.t.equals((Object)other)) {
            return true;
        }
        if (this.t.getFullyQualifiedName().equals(other.getFullyQualifiedName())) {
            return true;
        }
        if (this.t.getPackageName() == null && "java.lang".equals(other.getPackageName()) && this.t.getName().equalsIgnoreCase(other.getName())) {
            return true;
        }
        if (other.getPackageName() == null && "java.lang".equals(this.t.getPackageName()) && this.t.getName().equalsIgnoreCase(other.getName())) {
            return true;
        }
        if (visited.contains(other.getFullyQualifiedName())) {
            return false;
        }
        visited.add(this.t.getFullyQualifiedName());
        for (ClassRef e : other.getExtendsList()) {
            if (this.t.getFullyQualifiedName().equals(e.getFullyQualifiedName())) {
                return true;
            }
            if (!this.from(GetDefinition.of(e), visited).booleanValue()) continue;
            return true;
        }
        for (ClassRef i : other.getImplementsList()) {
            if (this.t.getFullyQualifiedName().equals(i.getFullyQualifiedName())) {
                return true;
            }
            if (!this.from(GetDefinition.of(i), visited).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

