/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.ClassLoadingResource;
import io.quarkus.bootstrap.runner.ManifestInfo;
import io.smallrye.common.io.jar.JarEntries;
import io.smallrye.common.io.jar.JarFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarResource
implements ClassLoadingResource {
    private final ManifestInfo manifestInfo;
    private final Path jarPath;
    private final Lock readLock;
    private final Lock writeLock;
    private volatile ProtectionDomain protectionDomain;
    private volatile JarFile zipFile;

    public JarResource(ManifestInfo manifestInfo, Path jarPath) {
        this.manifestInfo = manifestInfo;
        this.jarPath = jarPath;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    @Override
    public void init(ClassLoader runnerClassLoader) {
        URL url;
        try {
            Object path = this.jarPath.toAbsolutePath().toString();
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            URI uri = new URI("file", null, (String)path, null);
            url = uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Unable to create protection domain for " + this.jarPath, e);
        }
        this.protectionDomain = new ProtectionDomain(new CodeSource(url, (Certificate[])null), null, runnerClassLoader, null);
    }

    @Override
    public byte[] getResourceData(String resource) {
        JarFile zipFile = this.readLockAcquireAndGetJarReference();
        try {
            byte[] byArray;
            block15: {
                ZipEntry entry = ((ZipFile)zipFile).getEntry(resource);
                if (entry == null) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                InputStream is = ((ZipFile)zipFile).getInputStream(entry);
                try {
                    int read;
                    byte[] data = new byte[(int)entry.getSize()];
                    int pos = 0;
                    for (int rem = data.length; rem > 0; rem -= read) {
                        read = is.read(data, pos, rem);
                        if (read == -1) {
                            throw new RuntimeException("Failed to read all data for " + resource);
                        }
                        pos += read;
                    }
                    byArray = data;
                    if (is == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read zip entry " + resource, e);
                    }
                }
                is.close();
            }
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public URL getResourceURL(String resource) {
        JarFile jarFile = this.readLockAcquireAndGetJarReference();
        try {
            JarEntry entry = jarFile.getJarEntry(resource);
            if (entry == null) {
                URL uRL = null;
                return uRL;
            }
            String realName = JarEntries.getRealName((JarEntry)entry);
            if (realName.endsWith("/")) {
                realName = realName.substring(0, realName.length() - 1);
            }
            URI jarUri = this.jarPath.toUri();
            URL resUrl = new URI(jarUri.getScheme(), jarUri.getPath() + "!/" + realName, null).toURL();
            URL uRL = new URL("jar", null, resUrl.getProtocol() + ":" + resUrl.getPath() + (String)(resUrl.getQuery() == null ? "" : "%3F" + resUrl.getQuery()));
            return uRL;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ManifestInfo getManifestInfo() {
        return this.manifestInfo;
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    private JarFile readLockAcquireAndGetJarReference() {
        while (true) {
            this.readLock.lock();
            JarFile zipFileLocal = this.zipFile;
            if (zipFileLocal != null) {
                return zipFileLocal;
            }
            this.readLock.unlock();
            this.ensureJarFileIsOpen();
        }
    }

    private void ensureJarFileIsOpen() {
        block5: {
            this.writeLock.lock();
            try {
                if (this.zipFile != null) break block5;
                try {
                    this.zipFile = JarFiles.create((File)this.jarPath.toFile());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to open " + this.jarPath, e);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void close() {
        this.writeLock.lock();
        try {
            JarFile zipFileLocal = this.zipFile;
            if (zipFileLocal != null) {
                try {
                    this.zipFile = null;
                    zipFileLocal.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void resetInternalCaches() {
        this.close();
    }

    public String toString() {
        return "JarResource{" + this.jarPath.getFileName() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarResource that = (JarResource)o;
        return Objects.equals(this.manifestInfo, that.manifestInfo) && this.jarPath.equals(that.jarPath);
    }

    public int hashCode() {
        return Objects.hash(this.manifestInfo, this.jarPath);
    }
}

