/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.ClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.ClusterNetworkEntryFluentImpl;
import io.fabric8.openshift.api.model.ClusterNetworkFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterNetworkFluentImpl<A extends ClusterNetworkFluent<A>>
extends BaseFluent<A>
implements ClusterNetworkFluent<A> {
    private String apiVersion;
    private ArrayList<ClusterNetworkEntryBuilder> clusterNetworks = new ArrayList();
    private Integer hostsubnetlength;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Integer mtu;
    private String network;
    private String pluginName;
    private String serviceNetwork;
    private Integer vxlanPort;
    private Map<String, Object> additionalProperties;

    public ClusterNetworkFluentImpl() {
    }

    public ClusterNetworkFluentImpl(ClusterNetwork instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withClusterNetworks(instance.getClusterNetworks());
            this.withHostsubnetlength(instance.getHostsubnetlength());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withMtu(instance.getMtu());
            this.withNetwork(instance.getNetwork());
            this.withPluginName(instance.getPluginName());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withVxlanPort(instance.getVxlanPort());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToClusterNetworks(int index, ClusterNetworkEntry item) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetworks.size()) {
            this._visitables.get((Object)"clusterNetworks").add(builder);
            this.clusterNetworks.add(builder);
        } else {
            this._visitables.get((Object)"clusterNetworks").add(index, builder);
            this.clusterNetworks.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToClusterNetworks(int index, ClusterNetworkEntry item) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetworks.size()) {
            this._visitables.get((Object)"clusterNetworks").add(builder);
            this.clusterNetworks.add(builder);
        } else {
            this._visitables.get((Object)"clusterNetworks").set(index, builder);
            this.clusterNetworks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusterNetworks(ClusterNetworkEntry ... items) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetworks").add(builder);
            this.clusterNetworks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterNetworks(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetworks").add(builder);
            this.clusterNetworks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterNetworks(ClusterNetworkEntry ... items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetworks").remove(builder);
            if (this.clusterNetworks == null) continue;
            this.clusterNetworks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterNetworks(Collection<ClusterNetworkEntry> items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetworks").remove(builder);
            if (this.clusterNetworks == null) continue;
            this.clusterNetworks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.clusterNetworks == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.clusterNetworks.iterator();
        List visitables = this._visitables.get((Object)"clusterNetworks");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterNetworkEntry> getClusterNetworks() {
        return this.clusterNetworks != null ? ClusterNetworkFluentImpl.build(this.clusterNetworks) : null;
    }

    @Override
    public List<ClusterNetworkEntry> buildClusterNetworks() {
        return this.clusterNetworks != null ? ClusterNetworkFluentImpl.build(this.clusterNetworks) : null;
    }

    @Override
    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetworks.get(index).build();
    }

    @Override
    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetworks.get(0).build();
    }

    @Override
    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetworks.get(this.clusterNetworks.size() - 1).build();
    }

    @Override
    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetworks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetworks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterNetworks(List<ClusterNetworkEntry> clusterNetworks) {
        if (this.clusterNetworks != null) {
            this._visitables.get((Object)"clusterNetworks").clear();
        }
        if (clusterNetworks != null) {
            this.clusterNetworks = new ArrayList();
            for (ClusterNetworkEntry item : clusterNetworks) {
                this.addToClusterNetworks(item);
            }
        } else {
            this.clusterNetworks = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterNetworks(ClusterNetworkEntry ... clusterNetworks) {
        if (this.clusterNetworks != null) {
            this.clusterNetworks.clear();
            this._visitables.remove((Object)"clusterNetworks");
        }
        if (clusterNetworks != null) {
            for (ClusterNetworkEntry item : clusterNetworks) {
                this.addToClusterNetworks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterNetworks() {
        return this.clusterNetworks != null && !this.clusterNetworks.isEmpty();
    }

    @Override
    public A addNewClusterNetwork(String cidr, Integer hostSubnetLength) {
        return this.addToClusterNetworks(new ClusterNetworkEntry(cidr, hostSubnetLength));
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetwork() {
        return new ClusterNetworksNestedImpl();
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworksNestedImpl(-1, item);
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> setNewClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new ClusterNetworksNestedImpl(index, item);
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> editClusterNetwork(int index) {
        if (this.clusterNetworks.size() <= index) {
            throw new RuntimeException("Can't edit clusterNetworks. Index exceeds size.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> editFirstClusterNetwork() {
        if (this.clusterNetworks.size() == 0) {
            throw new RuntimeException("Can't edit first clusterNetworks. The list is empty.");
        }
        return this.setNewClusterNetworkLike(0, this.buildClusterNetwork(0));
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> editLastClusterNetwork() {
        int index = this.clusterNetworks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterNetworks. The list is empty.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterNetworks.size(); ++i) {
            if (!predicate.test(this.clusterNetworks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterNetworks. No match found.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public Integer getHostsubnetlength() {
        return this.hostsubnetlength;
    }

    @Override
    public A withHostsubnetlength(Integer hostsubnetlength) {
        this.hostsubnetlength = hostsubnetlength;
        return (A)this;
    }

    @Override
    public Boolean hasHostsubnetlength() {
        return this.hostsubnetlength != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ClusterNetworkFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterNetworkFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterNetworkFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ClusterNetworkFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ClusterNetworkFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public Integer getMtu() {
        return this.mtu;
    }

    @Override
    public A withMtu(Integer mtu) {
        this.mtu = mtu;
        return (A)this;
    }

    @Override
    public Boolean hasMtu() {
        return this.mtu != null;
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public A withNetwork(String network) {
        this.network = network;
        return (A)this;
    }

    @Override
    public Boolean hasNetwork() {
        return this.network != null;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public A withPluginName(String pluginName) {
        this.pluginName = pluginName;
        return (A)this;
    }

    @Override
    public Boolean hasPluginName() {
        return this.pluginName != null;
    }

    @Override
    public String getServiceNetwork() {
        return this.serviceNetwork;
    }

    @Override
    public A withServiceNetwork(String serviceNetwork) {
        this.serviceNetwork = serviceNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasServiceNetwork() {
        return this.serviceNetwork != null;
    }

    @Override
    public Integer getVxlanPort() {
        return this.vxlanPort;
    }

    @Override
    public A withVxlanPort(Integer vxlanPort) {
        this.vxlanPort = vxlanPort;
        return (A)this;
    }

    @Override
    public Boolean hasVxlanPort() {
        return this.vxlanPort != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterNetworkFluentImpl that = (ClusterNetworkFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.clusterNetworks, that.clusterNetworks)) {
            return false;
        }
        if (!Objects.equals(this.hostsubnetlength, that.hostsubnetlength)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.mtu, that.mtu)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.pluginName, that.pluginName)) {
            return false;
        }
        if (!Objects.equals(this.serviceNetwork, that.serviceNetwork)) {
            return false;
        }
        if (!Objects.equals(this.vxlanPort, that.vxlanPort)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.clusterNetworks, this.hostsubnetlength, this.kind, this.metadata, this.mtu, this.network, this.pluginName, this.serviceNetwork, this.vxlanPort, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.clusterNetworks != null && !this.clusterNetworks.isEmpty()) {
            sb.append("clusterNetworks:");
            sb.append(this.clusterNetworks + ",");
        }
        if (this.hostsubnetlength != null) {
            sb.append("hostsubnetlength:");
            sb.append(this.hostsubnetlength + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.mtu != null) {
            sb.append("mtu:");
            sb.append(this.mtu + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.pluginName != null) {
            sb.append("pluginName:");
            sb.append(this.pluginName + ",");
        }
        if (this.serviceNetwork != null) {
            sb.append("serviceNetwork:");
            sb.append(this.serviceNetwork + ",");
        }
        if (this.vxlanPort != null) {
            sb.append("vxlanPort:");
            sb.append(this.vxlanPort + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterNetworkFluent.MetadataNested<N>>
    implements ClusterNetworkFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ClusterNetworkFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class ClusterNetworksNestedImpl<N>
    extends ClusterNetworkEntryFluentImpl<ClusterNetworkFluent.ClusterNetworksNested<N>>
    implements ClusterNetworkFluent.ClusterNetworksNested<N>,
    Nested<N> {
        ClusterNetworkEntryBuilder builder;
        int index;

        ClusterNetworksNestedImpl(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        ClusterNetworksNestedImpl() {
            this.index = -1;
            this.builder = new ClusterNetworkEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterNetworkFluentImpl.this.setToClusterNetworks(this.index, this.builder.build());
        }

        @Override
        public N endClusterNetwork() {
            return this.and();
        }
    }
}

