/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.BuildVolume;
import io.fabric8.openshift.api.model.BuildVolumeFluent;
import io.fabric8.openshift.api.model.BuildVolumeMount;
import io.fabric8.openshift.api.model.BuildVolumeMountBuilder;
import io.fabric8.openshift.api.model.BuildVolumeMountFluentImpl;
import io.fabric8.openshift.api.model.BuildVolumeSource;
import io.fabric8.openshift.api.model.BuildVolumeSourceBuilder;
import io.fabric8.openshift.api.model.BuildVolumeSourceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildVolumeFluentImpl<A extends BuildVolumeFluent<A>>
extends BaseFluent<A>
implements BuildVolumeFluent<A> {
    private ArrayList<BuildVolumeMountBuilder> mounts = new ArrayList();
    private String name;
    private BuildVolumeSourceBuilder source;
    private Map<String, Object> additionalProperties;

    public BuildVolumeFluentImpl() {
    }

    public BuildVolumeFluentImpl(BuildVolume instance) {
        if (instance != null) {
            this.withMounts(instance.getMounts());
            this.withName(instance.getName());
            this.withSource(instance.getSource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToMounts(int index, BuildVolumeMount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
        if (index < 0 || index >= this.mounts.size()) {
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        } else {
            this._visitables.get((Object)"mounts").add(index, builder);
            this.mounts.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToMounts(int index, BuildVolumeMount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
        if (index < 0 || index >= this.mounts.size()) {
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        } else {
            this._visitables.get((Object)"mounts").set(index, builder);
            this.mounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMounts(BuildVolumeMount ... items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        for (BuildVolumeMount item : items) {
            BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMounts(Collection<BuildVolumeMount> items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        for (BuildVolumeMount item : items) {
            BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMounts(BuildVolumeMount ... items) {
        for (BuildVolumeMount item : items) {
            BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
            this._visitables.get((Object)"mounts").remove(builder);
            if (this.mounts == null) continue;
            this.mounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMounts(Collection<BuildVolumeMount> items) {
        for (BuildVolumeMount item : items) {
            BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
            this._visitables.get((Object)"mounts").remove(builder);
            if (this.mounts == null) continue;
            this.mounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMounts(Predicate<BuildVolumeMountBuilder> predicate) {
        if (this.mounts == null) {
            return (A)this;
        }
        Iterator<BuildVolumeMountBuilder> each = this.mounts.iterator();
        List visitables = this._visitables.get((Object)"mounts");
        while (each.hasNext()) {
            BuildVolumeMountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BuildVolumeMount> getMounts() {
        return this.mounts != null ? BuildVolumeFluentImpl.build(this.mounts) : null;
    }

    @Override
    public List<BuildVolumeMount> buildMounts() {
        return this.mounts != null ? BuildVolumeFluentImpl.build(this.mounts) : null;
    }

    @Override
    public BuildVolumeMount buildMount(int index) {
        return this.mounts.get(index).build();
    }

    @Override
    public BuildVolumeMount buildFirstMount() {
        return this.mounts.get(0).build();
    }

    @Override
    public BuildVolumeMount buildLastMount() {
        return this.mounts.get(this.mounts.size() - 1).build();
    }

    @Override
    public BuildVolumeMount buildMatchingMount(Predicate<BuildVolumeMountBuilder> predicate) {
        for (BuildVolumeMountBuilder item : this.mounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMount(Predicate<BuildVolumeMountBuilder> predicate) {
        for (BuildVolumeMountBuilder item : this.mounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMounts(List<BuildVolumeMount> mounts) {
        if (this.mounts != null) {
            this._visitables.get((Object)"mounts").clear();
        }
        if (mounts != null) {
            this.mounts = new ArrayList();
            for (BuildVolumeMount item : mounts) {
                this.addToMounts(item);
            }
        } else {
            this.mounts = null;
        }
        return (A)this;
    }

    @Override
    public A withMounts(BuildVolumeMount ... mounts) {
        if (this.mounts != null) {
            this.mounts.clear();
            this._visitables.remove((Object)"mounts");
        }
        if (mounts != null) {
            for (BuildVolumeMount item : mounts) {
                this.addToMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMounts() {
        return this.mounts != null && !this.mounts.isEmpty();
    }

    @Override
    public A addNewMount(String destinationPath) {
        return this.addToMounts(new BuildVolumeMount(destinationPath));
    }

    @Override
    public BuildVolumeFluent.MountsNested<A> addNewMount() {
        return new MountsNestedImpl();
    }

    @Override
    public BuildVolumeFluent.MountsNested<A> addNewMountLike(BuildVolumeMount item) {
        return new MountsNestedImpl(-1, item);
    }

    @Override
    public BuildVolumeFluent.MountsNested<A> setNewMountLike(int index, BuildVolumeMount item) {
        return new MountsNestedImpl(index, item);
    }

    @Override
    public BuildVolumeFluent.MountsNested<A> editMount(int index) {
        if (this.mounts.size() <= index) {
            throw new RuntimeException("Can't edit mounts. Index exceeds size.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public BuildVolumeFluent.MountsNested<A> editFirstMount() {
        if (this.mounts.size() == 0) {
            throw new RuntimeException("Can't edit first mounts. The list is empty.");
        }
        return this.setNewMountLike(0, this.buildMount(0));
    }

    @Override
    public BuildVolumeFluent.MountsNested<A> editLastMount() {
        int index = this.mounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last mounts. The list is empty.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public BuildVolumeFluent.MountsNested<A> editMatchingMount(Predicate<BuildVolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.mounts.size(); ++i) {
            if (!predicate.test(this.mounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching mounts. No match found.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public BuildVolumeSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public BuildVolumeSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(BuildVolumeSource source) {
        this._visitables.get((Object)"source").remove(this.source);
        if (source != null) {
            this.source = new BuildVolumeSourceBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get((Object)"source").remove(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public BuildVolumeFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public BuildVolumeFluent.SourceNested<A> withNewSourceLike(BuildVolumeSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public BuildVolumeFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public BuildVolumeFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new BuildVolumeSourceBuilder().build());
    }

    @Override
    public BuildVolumeFluent.SourceNested<A> editOrNewSourceLike(BuildVolumeSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildVolumeFluentImpl that = (BuildVolumeFluentImpl)o;
        if (!Objects.equals(this.mounts, that.mounts)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.mounts, this.name, this.source, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mounts != null && !this.mounts.isEmpty()) {
            sb.append("mounts:");
            sb.append(this.mounts + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SourceNestedImpl<N>
    extends BuildVolumeSourceFluentImpl<BuildVolumeFluent.SourceNested<N>>
    implements BuildVolumeFluent.SourceNested<N>,
    Nested<N> {
        BuildVolumeSourceBuilder builder;

        SourceNestedImpl(BuildVolumeSource item) {
            this.builder = new BuildVolumeSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new BuildVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildVolumeFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    class MountsNestedImpl<N>
    extends BuildVolumeMountFluentImpl<BuildVolumeFluent.MountsNested<N>>
    implements BuildVolumeFluent.MountsNested<N>,
    Nested<N> {
        BuildVolumeMountBuilder builder;
        int index;

        MountsNestedImpl(int index, BuildVolumeMount item) {
            this.index = index;
            this.builder = new BuildVolumeMountBuilder(this, item);
        }

        MountsNestedImpl() {
            this.index = -1;
            this.builder = new BuildVolumeMountBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildVolumeFluentImpl.this.setToMounts(this.index, this.builder.build());
        }

        @Override
        public N endMount() {
            return this.and();
        }
    }
}

