/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model;

import io.debezium.operator.api.model.DebeziumServerSpec;
import io.debezium.operator.api.model.DebeziumServerSpecFluent;
import io.debezium.operator.api.model.Format;
import io.debezium.operator.api.model.Predicate;
import io.debezium.operator.api.model.Quarkus;
import io.debezium.operator.api.model.Runtime;
import io.debezium.operator.api.model.Sink;
import io.debezium.operator.api.model.Source;
import io.debezium.operator.api.model.Storage;
import io.debezium.operator.api.model.Transformation;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DebeziumServerSpecFluentImpl<A extends DebeziumServerSpecFluent<A>>
extends BaseFluent<A>
implements DebeziumServerSpecFluent<A> {
    private String image;
    private String version;
    private Storage storage;
    private Sink sink;
    private Source source;
    private Format format;
    private Quarkus quarkus;
    private Runtime runtime;
    private List<Transformation> transforms = new ArrayList<Transformation>();
    private Map<String, Predicate> predicates;

    public DebeziumServerSpecFluentImpl() {
    }

    public DebeziumServerSpecFluentImpl(DebeziumServerSpec instance) {
        if (instance != null) {
            this.withImage(instance.getImage());
            this.withVersion(instance.getVersion());
            this.withStorage(instance.getStorage());
            this.withSink(instance.getSink());
            this.withSource(instance.getSource());
            this.withFormat(instance.getFormat());
            this.withQuarkus(instance.getQuarkus());
            this.withRuntime(instance.getRuntime());
            this.withTransforms(instance.getTransforms());
            this.withPredicates(instance.getPredicates());
        }
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public A withStorage(Storage storage) {
        this.storage = storage;
        return (A)this;
    }

    @Override
    public Boolean hasStorage() {
        return this.storage != null;
    }

    @Override
    public Sink getSink() {
        return this.sink;
    }

    @Override
    public A withSink(Sink sink) {
        this.sink = sink;
        return (A)this;
    }

    @Override
    public Boolean hasSink() {
        return this.sink != null;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public A withSource(Source source) {
        this.source = source;
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public A withFormat(Format format) {
        this.format = format;
        return (A)this;
    }

    @Override
    public Boolean hasFormat() {
        return this.format != null;
    }

    @Override
    public Quarkus getQuarkus() {
        return this.quarkus;
    }

    @Override
    public A withQuarkus(Quarkus quarkus) {
        this.quarkus = quarkus;
        return (A)this;
    }

    @Override
    public Boolean hasQuarkus() {
        return this.quarkus != null;
    }

    @Override
    public Runtime getRuntime() {
        return this.runtime;
    }

    @Override
    public A withRuntime(Runtime runtime) {
        this.runtime = runtime;
        return (A)this;
    }

    @Override
    public Boolean hasRuntime() {
        return this.runtime != null;
    }

    @Override
    public A addToTransforms(int index, Transformation item) {
        if (this.transforms == null) {
            this.transforms = new ArrayList<Transformation>();
        }
        this.transforms.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTransforms(int index, Transformation item) {
        if (this.transforms == null) {
            this.transforms = new ArrayList<Transformation>();
        }
        this.transforms.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTransforms(Transformation ... items) {
        if (this.transforms == null) {
            this.transforms = new ArrayList<Transformation>();
        }
        for (Transformation item : items) {
            this.transforms.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTransforms(Collection<Transformation> items) {
        if (this.transforms == null) {
            this.transforms = new ArrayList<Transformation>();
        }
        for (Transformation item : items) {
            this.transforms.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTransforms(Transformation ... items) {
        for (Transformation item : items) {
            if (this.transforms == null) continue;
            this.transforms.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTransforms(Collection<Transformation> items) {
        for (Transformation item : items) {
            if (this.transforms == null) continue;
            this.transforms.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Transformation> getTransforms() {
        return this.transforms;
    }

    @Override
    public Transformation getTransform(int index) {
        return this.transforms.get(index);
    }

    @Override
    public Transformation getFirstTransform() {
        return this.transforms.get(0);
    }

    @Override
    public Transformation getLastTransform() {
        return this.transforms.get(this.transforms.size() - 1);
    }

    @Override
    public Transformation getMatchingTransform(java.util.function.Predicate<Transformation> predicate) {
        for (Transformation item : this.transforms) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTransform(java.util.function.Predicate<Transformation> predicate) {
        for (Transformation item : this.transforms) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTransforms(List<Transformation> transforms) {
        if (transforms != null) {
            this.transforms = new ArrayList<Transformation>();
            for (Transformation item : transforms) {
                this.addToTransforms(item);
            }
        } else {
            this.transforms = null;
        }
        return (A)this;
    }

    @Override
    public A withTransforms(Transformation ... transforms) {
        if (this.transforms != null) {
            this.transforms.clear();
            this._visitables.remove((Object)"transforms");
        }
        if (transforms != null) {
            for (Transformation item : transforms) {
                this.addToTransforms(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTransforms() {
        return this.transforms != null && !this.transforms.isEmpty();
    }

    @Override
    public A addToPredicates(String key, Predicate value) {
        if (this.predicates == null && key != null && value != null) {
            this.predicates = new LinkedHashMap<String, Predicate>();
        }
        if (key != null && value != null) {
            this.predicates.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToPredicates(Map<String, Predicate> map) {
        if (this.predicates == null && map != null) {
            this.predicates = new LinkedHashMap<String, Predicate>();
        }
        if (map != null) {
            this.predicates.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromPredicates(String key) {
        if (this.predicates == null) {
            return (A)this;
        }
        if (key != null && this.predicates != null) {
            this.predicates.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromPredicates(Map<String, Predicate> map) {
        if (this.predicates == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.predicates == null) continue;
                this.predicates.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Predicate> getPredicates() {
        return this.predicates;
    }

    @Override
    public <K, V> A withPredicates(Map<String, Predicate> predicates) {
        this.predicates = predicates == null ? null : new LinkedHashMap<String, Predicate>(predicates);
        return (A)this;
    }

    @Override
    public Boolean hasPredicates() {
        return this.predicates != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DebeziumServerSpecFluentImpl that = (DebeziumServerSpecFluentImpl)o;
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.sink, that.sink)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.format, that.format)) {
            return false;
        }
        if (!Objects.equals(this.quarkus, that.quarkus)) {
            return false;
        }
        if (!Objects.equals(this.runtime, that.runtime)) {
            return false;
        }
        if (!Objects.equals(this.transforms, that.transforms)) {
            return false;
        }
        return Objects.equals(this.predicates, that.predicates);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.version, this.storage, this.sink, this.source, this.format, this.quarkus, this.runtime, this.transforms, this.predicates, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.sink != null) {
            sb.append("sink:");
            sb.append(this.sink + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.format != null) {
            sb.append("format:");
            sb.append(this.format + ",");
        }
        if (this.quarkus != null) {
            sb.append("quarkus:");
            sb.append(this.quarkus + ",");
        }
        if (this.runtime != null) {
            sb.append("runtime:");
            sb.append(this.runtime + ",");
        }
        if (this.transforms != null && !this.transforms.isEmpty()) {
            sb.append("transforms:");
            sb.append(this.transforms + ",");
        }
        if (this.predicates != null && !this.predicates.isEmpty()) {
            sb.append("predicates:");
            sb.append(this.predicates);
        }
        sb.append("}");
        return sb.toString();
    }
}

