/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.openstack.v1.Platform;
import io.fabric8.openshift.api.model.installer.openstack.v1.PlatformFluent;
import io.fabric8.openshift.api.model.installer.openstack.v1.PlatformFluentImpl;

public class PlatformBuilder
extends PlatformFluentImpl<PlatformBuilder>
implements VisitableBuilder<Platform, PlatformBuilder> {
    PlatformFluent<?> fluent;
    Boolean validationEnabled;

    public PlatformBuilder() {
        this(false);
    }

    public PlatformBuilder(Boolean validationEnabled) {
        this(new Platform(), validationEnabled);
    }

    public PlatformBuilder(PlatformFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Platform(), validationEnabled);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Platform instance) {
        this(fluent, instance, false);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Platform instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiFloatingIP(instance.getApiFloatingIP());
            fluent.withApiVIP(instance.getApiVIP());
            fluent.withCloud(instance.getCloud());
            fluent.withClusterOSImage(instance.getClusterOSImage());
            fluent.withClusterOSImageProperties(instance.getClusterOSImageProperties());
            fluent.withComputeFlavor(instance.getComputeFlavor());
            fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            fluent.withExternalDNS(instance.getExternalDNS());
            fluent.withExternalNetwork(instance.getExternalNetwork());
            fluent.withIngressFloatingIP(instance.getIngressFloatingIP());
            fluent.withIngressVIP(instance.getIngressVIP());
            fluent.withLbFloatingIP(instance.getLbFloatingIP());
            fluent.withMachinesSubnet(instance.getMachinesSubnet());
            fluent.withOctaviaSupport(instance.getOctaviaSupport());
            fluent.withRegion(instance.getRegion());
            fluent.withTrunkSupport(instance.getTrunkSupport());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public PlatformBuilder(Platform instance) {
        this(instance, (Boolean)false);
    }

    public PlatformBuilder(Platform instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiFloatingIP(instance.getApiFloatingIP());
            this.withApiVIP(instance.getApiVIP());
            this.withCloud(instance.getCloud());
            this.withClusterOSImage(instance.getClusterOSImage());
            this.withClusterOSImageProperties(instance.getClusterOSImageProperties());
            this.withComputeFlavor(instance.getComputeFlavor());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withExternalDNS(instance.getExternalDNS());
            this.withExternalNetwork(instance.getExternalNetwork());
            this.withIngressFloatingIP(instance.getIngressFloatingIP());
            this.withIngressVIP(instance.getIngressVIP());
            this.withLbFloatingIP(instance.getLbFloatingIP());
            this.withMachinesSubnet(instance.getMachinesSubnet());
            this.withOctaviaSupport(instance.getOctaviaSupport());
            this.withRegion(instance.getRegion());
            this.withTrunkSupport(instance.getTrunkSupport());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public Platform build() {
        Platform buildable = new Platform(this.fluent.getApiFloatingIP(), this.fluent.getApiVIP(), this.fluent.getCloud(), this.fluent.getClusterOSImage(), this.fluent.getClusterOSImageProperties(), this.fluent.getComputeFlavor(), this.fluent.getDefaultMachinePlatform(), this.fluent.getExternalDNS(), this.fluent.getExternalNetwork(), this.fluent.getIngressFloatingIP(), this.fluent.getIngressVIP(), this.fluent.getLbFloatingIP(), this.fluent.getMachinesSubnet(), this.fluent.getOctaviaSupport(), this.fluent.getRegion(), this.fluent.getTrunkSupport());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

