/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.OSDisk;
import io.fabric8.openshift.api.model.installer.gcp.v1.OSDiskFluent;
import io.fabric8.openshift.api.model.installer.gcp.v1.OSDiskFluentImpl;

public class OSDiskBuilder
extends OSDiskFluentImpl<OSDiskBuilder>
implements VisitableBuilder<OSDisk, OSDiskBuilder> {
    OSDiskFluent<?> fluent;
    Boolean validationEnabled;

    public OSDiskBuilder() {
        this(false);
    }

    public OSDiskBuilder(Boolean validationEnabled) {
        this(new OSDisk(), validationEnabled);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OSDisk(), validationEnabled);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent, OSDisk instance) {
        this(fluent, instance, false);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent, OSDisk instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withDiskSizeGB(instance.getDiskSizeGB());
            fluent.withDiskType(instance.getDiskType());
            fluent.withEncryptionKey(instance.getEncryptionKey());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public OSDiskBuilder(OSDisk instance) {
        this(instance, (Boolean)false);
    }

    public OSDiskBuilder(OSDisk instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withDiskSizeGB(instance.getDiskSizeGB());
            this.withDiskType(instance.getDiskType());
            this.withEncryptionKey(instance.getEncryptionKey());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public OSDisk build() {
        OSDisk buildable = new OSDisk(this.fluent.getDiskSizeGB(), this.fluent.getDiskType(), this.fluent.getEncryptionKey());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

