/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.baremetal.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.baremetal.v1.Host;
import io.fabric8.openshift.api.model.installer.baremetal.v1.HostBuilder;
import io.fabric8.openshift.api.model.installer.baremetal.v1.HostFluentImpl;
import io.fabric8.openshift.api.model.installer.baremetal.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.baremetal.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.baremetal.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.installer.baremetal.v1.Platform;
import io.fabric8.openshift.api.model.installer.baremetal.v1.PlatformFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private String apiVIP;
    private String bootstrapOSImage;
    private String bootstrapProvisioningIP;
    private String clusterOSImage;
    private String clusterProvisioningIP;
    private MachinePoolBuilder defaultMachinePlatform;
    private String externalBridge;
    private String externalMACAddress;
    private ArrayList<HostBuilder> hosts = new ArrayList();
    private String ingressVIP;
    private String libvirtURI;
    private String provisioningBridge;
    private Boolean provisioningDHCPExternal;
    private String provisioningDHCPRange;
    private String provisioningHostIP;
    private String provisioningMACAddress;
    private String provisioningNetwork;
    private String provisioningNetworkCIDR;
    private String provisioningNetworkInterface;
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        if (instance != null) {
            this.withApiVIP(instance.getApiVIP());
            this.withBootstrapOSImage(instance.getBootstrapOSImage());
            this.withBootstrapProvisioningIP(instance.getBootstrapProvisioningIP());
            this.withClusterOSImage(instance.getClusterOSImage());
            this.withClusterProvisioningIP(instance.getClusterProvisioningIP());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withExternalBridge(instance.getExternalBridge());
            this.withExternalMACAddress(instance.getExternalMACAddress());
            this.withHosts(instance.getHosts());
            this.withIngressVIP(instance.getIngressVIP());
            this.withLibvirtURI(instance.getLibvirtURI());
            this.withProvisioningBridge(instance.getProvisioningBridge());
            this.withProvisioningDHCPExternal(instance.getProvisioningDHCPExternal());
            this.withProvisioningDHCPRange(instance.getProvisioningDHCPRange());
            this.withProvisioningHostIP(instance.getProvisioningHostIP());
            this.withProvisioningMACAddress(instance.getProvisioningMACAddress());
            this.withProvisioningNetwork(instance.getProvisioningNetwork());
            this.withProvisioningNetworkCIDR(instance.getProvisioningNetworkCIDR());
            this.withProvisioningNetworkInterface(instance.getProvisioningNetworkInterface());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVIP() {
        return this.apiVIP;
    }

    @Override
    public A withApiVIP(String apiVIP) {
        this.apiVIP = apiVIP;
        return (A)this;
    }

    @Override
    public Boolean hasApiVIP() {
        return this.apiVIP != null;
    }

    @Override
    public String getBootstrapOSImage() {
        return this.bootstrapOSImage;
    }

    @Override
    public A withBootstrapOSImage(String bootstrapOSImage) {
        this.bootstrapOSImage = bootstrapOSImage;
        return (A)this;
    }

    @Override
    public Boolean hasBootstrapOSImage() {
        return this.bootstrapOSImage != null;
    }

    @Override
    public String getBootstrapProvisioningIP() {
        return this.bootstrapProvisioningIP;
    }

    @Override
    public A withBootstrapProvisioningIP(String bootstrapProvisioningIP) {
        this.bootstrapProvisioningIP = bootstrapProvisioningIP;
        return (A)this;
    }

    @Override
    public Boolean hasBootstrapProvisioningIP() {
        return this.bootstrapProvisioningIP != null;
    }

    @Override
    public String getClusterOSImage() {
        return this.clusterOSImage;
    }

    @Override
    public A withClusterOSImage(String clusterOSImage) {
        this.clusterOSImage = clusterOSImage;
        return (A)this;
    }

    @Override
    public Boolean hasClusterOSImage() {
        return this.clusterOSImage != null;
    }

    @Override
    public String getClusterProvisioningIP() {
        return this.clusterProvisioningIP;
    }

    @Override
    public A withClusterProvisioningIP(String clusterProvisioningIP) {
        this.clusterProvisioningIP = clusterProvisioningIP;
        return (A)this;
    }

    @Override
    public Boolean hasClusterProvisioningIP() {
        return this.clusterProvisioningIP != null;
    }

    @Override
    @Deprecated
    public MachinePool getDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get((Object)"defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get((Object)"defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get((Object)"defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNestedImpl();
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNestedImpl(item);
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : new MachinePoolBuilder().build());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : item);
    }

    @Override
    public String getExternalBridge() {
        return this.externalBridge;
    }

    @Override
    public A withExternalBridge(String externalBridge) {
        this.externalBridge = externalBridge;
        return (A)this;
    }

    @Override
    public Boolean hasExternalBridge() {
        return this.externalBridge != null;
    }

    @Override
    public String getExternalMACAddress() {
        return this.externalMACAddress;
    }

    @Override
    public A withExternalMACAddress(String externalMACAddress) {
        this.externalMACAddress = externalMACAddress;
        return (A)this;
    }

    @Override
    public Boolean hasExternalMACAddress() {
        return this.externalMACAddress != null;
    }

    @Override
    public A addToHosts(int index, Host item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList();
        }
        HostBuilder builder = new HostBuilder(item);
        if (index < 0 || index >= this.hosts.size()) {
            this._visitables.get((Object)"hosts").add(builder);
            this.hosts.add(builder);
        } else {
            this._visitables.get((Object)"hosts").add(index, builder);
            this.hosts.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToHosts(int index, Host item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList();
        }
        HostBuilder builder = new HostBuilder(item);
        if (index < 0 || index >= this.hosts.size()) {
            this._visitables.get((Object)"hosts").add(builder);
            this.hosts.add(builder);
        } else {
            this._visitables.get((Object)"hosts").set(index, builder);
            this.hosts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHosts(Host ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList();
        }
        for (Host item : items) {
            HostBuilder builder = new HostBuilder(item);
            this._visitables.get((Object)"hosts").add(builder);
            this.hosts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHosts(Collection<Host> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList();
        }
        for (Host item : items) {
            HostBuilder builder = new HostBuilder(item);
            this._visitables.get((Object)"hosts").add(builder);
            this.hosts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(Host ... items) {
        for (Host item : items) {
            HostBuilder builder = new HostBuilder(item);
            this._visitables.get((Object)"hosts").remove(builder);
            if (this.hosts == null) continue;
            this.hosts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHosts(Collection<Host> items) {
        for (Host item : items) {
            HostBuilder builder = new HostBuilder(item);
            this._visitables.get((Object)"hosts").remove(builder);
            if (this.hosts == null) continue;
            this.hosts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHosts(Predicate<HostBuilder> predicate) {
        if (this.hosts == null) {
            return (A)this;
        }
        Iterator<HostBuilder> each = this.hosts.iterator();
        List visitables = this._visitables.get((Object)"hosts");
        while (each.hasNext()) {
            HostBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Host> getHosts() {
        return this.hosts != null ? PlatformFluentImpl.build(this.hosts) : null;
    }

    @Override
    public List<Host> buildHosts() {
        return this.hosts != null ? PlatformFluentImpl.build(this.hosts) : null;
    }

    @Override
    public Host buildHost(int index) {
        return this.hosts.get(index).build();
    }

    @Override
    public Host buildFirstHost() {
        return this.hosts.get(0).build();
    }

    @Override
    public Host buildLastHost() {
        return this.hosts.get(this.hosts.size() - 1).build();
    }

    @Override
    public Host buildMatchingHost(Predicate<HostBuilder> predicate) {
        for (HostBuilder item : this.hosts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHost(Predicate<HostBuilder> predicate) {
        for (HostBuilder item : this.hosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHosts(List<Host> hosts) {
        if (this.hosts != null) {
            this._visitables.get((Object)"hosts").clear();
        }
        if (hosts != null) {
            this.hosts = new ArrayList();
            for (Host item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    @Override
    public A withHosts(Host ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
            this._visitables.remove((Object)"hosts");
        }
        if (hosts != null) {
            for (Host item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    @Override
    public PlatformFluent.HostsNested<A> addNewHost() {
        return new HostsNestedImpl();
    }

    @Override
    public PlatformFluent.HostsNested<A> addNewHostLike(Host item) {
        return new HostsNestedImpl(-1, item);
    }

    @Override
    public PlatformFluent.HostsNested<A> setNewHostLike(int index, Host item) {
        return new HostsNestedImpl(index, item);
    }

    @Override
    public PlatformFluent.HostsNested<A> editHost(int index) {
        if (this.hosts.size() <= index) {
            throw new RuntimeException("Can't edit hosts. Index exceeds size.");
        }
        return this.setNewHostLike(index, this.buildHost(index));
    }

    @Override
    public PlatformFluent.HostsNested<A> editFirstHost() {
        if (this.hosts.size() == 0) {
            throw new RuntimeException("Can't edit first hosts. The list is empty.");
        }
        return this.setNewHostLike(0, this.buildHost(0));
    }

    @Override
    public PlatformFluent.HostsNested<A> editLastHost() {
        int index = this.hosts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hosts. The list is empty.");
        }
        return this.setNewHostLike(index, this.buildHost(index));
    }

    @Override
    public PlatformFluent.HostsNested<A> editMatchingHost(Predicate<HostBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hosts.size(); ++i) {
            if (!predicate.test(this.hosts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hosts. No match found.");
        }
        return this.setNewHostLike(index, this.buildHost(index));
    }

    @Override
    public String getIngressVIP() {
        return this.ingressVIP;
    }

    @Override
    public A withIngressVIP(String ingressVIP) {
        this.ingressVIP = ingressVIP;
        return (A)this;
    }

    @Override
    public Boolean hasIngressVIP() {
        return this.ingressVIP != null;
    }

    @Override
    public String getLibvirtURI() {
        return this.libvirtURI;
    }

    @Override
    public A withLibvirtURI(String libvirtURI) {
        this.libvirtURI = libvirtURI;
        return (A)this;
    }

    @Override
    public Boolean hasLibvirtURI() {
        return this.libvirtURI != null;
    }

    @Override
    public String getProvisioningBridge() {
        return this.provisioningBridge;
    }

    @Override
    public A withProvisioningBridge(String provisioningBridge) {
        this.provisioningBridge = provisioningBridge;
        return (A)this;
    }

    @Override
    public Boolean hasProvisioningBridge() {
        return this.provisioningBridge != null;
    }

    @Override
    public Boolean getProvisioningDHCPExternal() {
        return this.provisioningDHCPExternal;
    }

    @Override
    public A withProvisioningDHCPExternal(Boolean provisioningDHCPExternal) {
        this.provisioningDHCPExternal = provisioningDHCPExternal;
        return (A)this;
    }

    @Override
    public Boolean hasProvisioningDHCPExternal() {
        return this.provisioningDHCPExternal != null;
    }

    @Override
    public String getProvisioningDHCPRange() {
        return this.provisioningDHCPRange;
    }

    @Override
    public A withProvisioningDHCPRange(String provisioningDHCPRange) {
        this.provisioningDHCPRange = provisioningDHCPRange;
        return (A)this;
    }

    @Override
    public Boolean hasProvisioningDHCPRange() {
        return this.provisioningDHCPRange != null;
    }

    @Override
    public String getProvisioningHostIP() {
        return this.provisioningHostIP;
    }

    @Override
    public A withProvisioningHostIP(String provisioningHostIP) {
        this.provisioningHostIP = provisioningHostIP;
        return (A)this;
    }

    @Override
    public Boolean hasProvisioningHostIP() {
        return this.provisioningHostIP != null;
    }

    @Override
    public String getProvisioningMACAddress() {
        return this.provisioningMACAddress;
    }

    @Override
    public A withProvisioningMACAddress(String provisioningMACAddress) {
        this.provisioningMACAddress = provisioningMACAddress;
        return (A)this;
    }

    @Override
    public Boolean hasProvisioningMACAddress() {
        return this.provisioningMACAddress != null;
    }

    @Override
    public String getProvisioningNetwork() {
        return this.provisioningNetwork;
    }

    @Override
    public A withProvisioningNetwork(String provisioningNetwork) {
        this.provisioningNetwork = provisioningNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasProvisioningNetwork() {
        return this.provisioningNetwork != null;
    }

    @Override
    public String getProvisioningNetworkCIDR() {
        return this.provisioningNetworkCIDR;
    }

    @Override
    public A withProvisioningNetworkCIDR(String provisioningNetworkCIDR) {
        this.provisioningNetworkCIDR = provisioningNetworkCIDR;
        return (A)this;
    }

    @Override
    public Boolean hasProvisioningNetworkCIDR() {
        return this.provisioningNetworkCIDR != null;
    }

    @Override
    public String getProvisioningNetworkInterface() {
        return this.provisioningNetworkInterface;
    }

    @Override
    public A withProvisioningNetworkInterface(String provisioningNetworkInterface) {
        this.provisioningNetworkInterface = provisioningNetworkInterface;
        return (A)this;
    }

    @Override
    public Boolean hasProvisioningNetworkInterface() {
        return this.provisioningNetworkInterface != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (!Objects.equals(this.apiVIP, that.apiVIP)) {
            return false;
        }
        if (!Objects.equals(this.bootstrapOSImage, that.bootstrapOSImage)) {
            return false;
        }
        if (!Objects.equals(this.bootstrapProvisioningIP, that.bootstrapProvisioningIP)) {
            return false;
        }
        if (!Objects.equals(this.clusterOSImage, that.clusterOSImage)) {
            return false;
        }
        if (!Objects.equals(this.clusterProvisioningIP, that.clusterProvisioningIP)) {
            return false;
        }
        if (!Objects.equals(this.defaultMachinePlatform, that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.externalBridge, that.externalBridge)) {
            return false;
        }
        if (!Objects.equals(this.externalMACAddress, that.externalMACAddress)) {
            return false;
        }
        if (!Objects.equals(this.hosts, that.hosts)) {
            return false;
        }
        if (!Objects.equals(this.ingressVIP, that.ingressVIP)) {
            return false;
        }
        if (!Objects.equals(this.libvirtURI, that.libvirtURI)) {
            return false;
        }
        if (!Objects.equals(this.provisioningBridge, that.provisioningBridge)) {
            return false;
        }
        if (!Objects.equals(this.provisioningDHCPExternal, that.provisioningDHCPExternal)) {
            return false;
        }
        if (!Objects.equals(this.provisioningDHCPRange, that.provisioningDHCPRange)) {
            return false;
        }
        if (!Objects.equals(this.provisioningHostIP, that.provisioningHostIP)) {
            return false;
        }
        if (!Objects.equals(this.provisioningMACAddress, that.provisioningMACAddress)) {
            return false;
        }
        if (!Objects.equals(this.provisioningNetwork, that.provisioningNetwork)) {
            return false;
        }
        if (!Objects.equals(this.provisioningNetworkCIDR, that.provisioningNetworkCIDR)) {
            return false;
        }
        if (!Objects.equals(this.provisioningNetworkInterface, that.provisioningNetworkInterface)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVIP, this.bootstrapOSImage, this.bootstrapProvisioningIP, this.clusterOSImage, this.clusterProvisioningIP, this.defaultMachinePlatform, this.externalBridge, this.externalMACAddress, this.hosts, this.ingressVIP, this.libvirtURI, this.provisioningBridge, this.provisioningDHCPExternal, this.provisioningDHCPRange, this.provisioningHostIP, this.provisioningMACAddress, this.provisioningNetwork, this.provisioningNetworkCIDR, this.provisioningNetworkInterface, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVIP != null) {
            sb.append("apiVIP:");
            sb.append(this.apiVIP + ",");
        }
        if (this.bootstrapOSImage != null) {
            sb.append("bootstrapOSImage:");
            sb.append(this.bootstrapOSImage + ",");
        }
        if (this.bootstrapProvisioningIP != null) {
            sb.append("bootstrapProvisioningIP:");
            sb.append(this.bootstrapProvisioningIP + ",");
        }
        if (this.clusterOSImage != null) {
            sb.append("clusterOSImage:");
            sb.append(this.clusterOSImage + ",");
        }
        if (this.clusterProvisioningIP != null) {
            sb.append("clusterProvisioningIP:");
            sb.append(this.clusterProvisioningIP + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.externalBridge != null) {
            sb.append("externalBridge:");
            sb.append(this.externalBridge + ",");
        }
        if (this.externalMACAddress != null) {
            sb.append("externalMACAddress:");
            sb.append(this.externalMACAddress + ",");
        }
        if (this.hosts != null) {
            sb.append("hosts:");
            sb.append(this.hosts + ",");
        }
        if (this.ingressVIP != null) {
            sb.append("ingressVIP:");
            sb.append(this.ingressVIP + ",");
        }
        if (this.libvirtURI != null) {
            sb.append("libvirtURI:");
            sb.append(this.libvirtURI + ",");
        }
        if (this.provisioningBridge != null) {
            sb.append("provisioningBridge:");
            sb.append(this.provisioningBridge + ",");
        }
        if (this.provisioningDHCPExternal != null) {
            sb.append("provisioningDHCPExternal:");
            sb.append(this.provisioningDHCPExternal + ",");
        }
        if (this.provisioningDHCPRange != null) {
            sb.append("provisioningDHCPRange:");
            sb.append(this.provisioningDHCPRange + ",");
        }
        if (this.provisioningHostIP != null) {
            sb.append("provisioningHostIP:");
            sb.append(this.provisioningHostIP + ",");
        }
        if (this.provisioningMACAddress != null) {
            sb.append("provisioningMACAddress:");
            sb.append(this.provisioningMACAddress + ",");
        }
        if (this.provisioningNetwork != null) {
            sb.append("provisioningNetwork:");
            sb.append(this.provisioningNetwork + ",");
        }
        if (this.provisioningNetworkCIDR != null) {
            sb.append("provisioningNetworkCIDR:");
            sb.append(this.provisioningNetworkCIDR + ",");
        }
        if (this.provisioningNetworkInterface != null) {
            sb.append("provisioningNetworkInterface:");
            sb.append(this.provisioningNetworkInterface + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withProvisioningDHCPExternal() {
        return this.withProvisioningDHCPExternal(true);
    }

    class HostsNestedImpl<N>
    extends HostFluentImpl<PlatformFluent.HostsNested<N>>
    implements PlatformFluent.HostsNested<N>,
    Nested<N> {
        HostBuilder builder;
        int index;

        HostsNestedImpl(int index, Host item) {
            this.index = index;
            this.builder = new HostBuilder(this, item);
        }

        HostsNestedImpl() {
            this.index = -1;
            this.builder = new HostBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.setToHosts(this.index, this.builder.build());
        }

        @Override
        public N endHost() {
            return this.and();
        }
    }

    class DefaultMachinePlatformNestedImpl<N>
    extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>>
    implements PlatformFluent.DefaultMachinePlatformNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        DefaultMachinePlatformNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withDefaultMachinePlatform(this.builder.build());
        }

        @Override
        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

