/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.functions;

import io.sundr.model.ClassRef;
import io.sundr.model.Nameable;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.repo.DefinitionRepository;
import java.util.function.Function;

public class GetDefinition
implements Function<ClassRef, TypeDef> {
    public static GetDefinition FUNCTION = new GetDefinition();

    public static TypeDef of(ClassRef classRef) {
        return FUNCTION.apply(classRef);
    }

    public static TypeDef of(String fqcn) {
        return FUNCTION.apply(ClassRef.forName((String)fqcn));
    }

    @Override
    public TypeDef apply(ClassRef t) {
        String fullyQualifiedName = t.getFullyQualifiedName();
        TypeDef def = DefinitionRepository.getRepository().getDefinition(fullyQualifiedName);
        if (def != null) {
            return def;
        }
        String packageName = Nameable.getPackageName((String)fullyQualifiedName);
        String className = Nameable.getClassName((String)fullyQualifiedName);
        String outerTypeName = Nameable.getOuterTypeName((String)fullyQualifiedName);
        return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withName(className)).withPackageName(packageName)).withOuterTypeName(outerTypeName)).build();
    }
}

