/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.docs.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Documentation {
    private final String title;
    private final List<TypeDescription> types;
    private final Set<String> typeNames;
    private Map<String, Set<String>> usageReference = new HashMap<String, Set<String>>();

    public Documentation(String title) {
        this.title = title;
        this.types = new ArrayList<TypeDescription>();
        this.typeNames = new HashSet<String>();
    }

    public Documentation addTypeDescription(TypeDescription type) {
        this.types.add(type);
        this.typeNames.add(type.name);
        type.fields().forEach(field -> this.usageReference.computeIfAbsent(field.typeRef(), k -> new HashSet()).add(type.name()));
        return this;
    }

    public String title() {
        return this.title;
    }

    public List<TypeDescription> types() {
        return this.types;
    }

    public Set<String> typeNames() {
        return this.typeNames;
    }

    public boolean isKnownType(String name) {
        return this.typeNames.contains(name);
    }

    public Set<String> getUsages(String name) {
        return this.usageReference.getOrDefault(name, Set.of());
    }

    public record TypeDescription(String name, List<FieldDescription> fields) {
    }

    public record FieldDescription(String name, String type, String typeRef, String externalTypeRef, String defaultValue, String description) {
    }

    public static class TypeDescriptionBuilder {
        private final String name;
        private final List<FieldDescription> fields = new ArrayList<FieldDescription>();

        public TypeDescriptionBuilder(String name) {
            this.name = name;
        }

        public TypeDescriptionBuilder addFieldDescription(FieldDescription field) {
            this.fields.add(field);
            return this;
        }

        public TypeDescription build() {
            Objects.requireNonNull(this.name);
            return new TypeDescription(this.name, this.fields);
        }
    }
}

