/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event;

import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceInitializer;
import io.javaoperatorsdk.operator.processing.event.EventHandler;
import io.javaoperatorsdk.operator.processing.event.EventSourceMetadata;
import io.javaoperatorsdk.operator.processing.event.source.Configurable;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.processing.event.source.EventSourceStartPriority;
import io.javaoperatorsdk.operator.processing.event.source.ResourceEventSource;
import java.util.Objects;
import java.util.Optional;

class NamedEventSource
implements EventSource,
EventSourceMetadata {
    private final EventSource original;
    private final String name;
    private final boolean nameSet;

    NamedEventSource(EventSource original, String name) {
        this.original = original;
        this.name = name;
        this.nameSet = !name.equals(EventSourceInitializer.generateNameFor(original));
    }

    @Override
    public void start() throws OperatorException {
        this.original.start();
    }

    @Override
    public void stop() throws OperatorException {
        this.original.stop();
    }

    @Override
    public void setEventHandler(EventHandler handler) {
        this.original.setEventHandler(handler);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Class<?> type() {
        return this.original.getClass();
    }

    @Override
    public Optional<Class<?>> resourceType() {
        if (this.original instanceof ResourceEventSource) {
            ResourceEventSource resourceEventSource = (ResourceEventSource)this.original;
            return Optional.of(resourceEventSource.resourceType());
        }
        return Optional.empty();
    }

    @Override
    public Optional<?> configuration() {
        if (this.original instanceof Configurable) {
            Configurable configurable = (Configurable)((Object)this.original);
            return Optional.ofNullable(configurable.configuration());
        }
        return Optional.empty();
    }

    public EventSource eventSource() {
        return this.original;
    }

    public String toString() {
        return this.original + " named: " + this.name;
    }

    public EventSource original() {
        return this.original;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedEventSource that = (NamedEventSource)o;
        return Objects.equals(this.original, that.original) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.original, this.name);
    }

    @Override
    public EventSourceStartPriority priority() {
        return this.original.priority();
    }

    public boolean isNameSet() {
        return this.nameSet;
    }
}

