/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointSlice;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.GenericKubernetesResourceMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.ResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.ClusterRoleBindingResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.ClusterRoleResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.ConfigMapResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.EndpointSliceResourceUpdateMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.EndpointsResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.RoleBindingResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.RoleResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.SecretResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.ServiceAccountResourceUpdaterMatcher;
import java.util.Map;

public class GenericResourceUpdaterMatcher<R extends HasMetadata>
implements ResourceUpdaterMatcher<R> {
    private static final ResourceUpdaterMatcher<?> INSTANCE = new GenericResourceUpdaterMatcher();
    private static final Map<Class, ResourceUpdaterMatcher> processors = Map.of(Secret.class, new SecretResourceUpdaterMatcher(), ConfigMap.class, new ConfigMapResourceUpdaterMatcher(), ServiceAccount.class, new ServiceAccountResourceUpdaterMatcher(), Role.class, new RoleResourceUpdaterMatcher(), ClusterRole.class, new ClusterRoleResourceUpdaterMatcher(), RoleBinding.class, new RoleBindingResourceUpdaterMatcher(), ClusterRoleBinding.class, new ClusterRoleBindingResourceUpdaterMatcher(), Endpoints.class, new EndpointsResourceUpdaterMatcher(), EndpointSlice.class, new EndpointSliceResourceUpdateMatcher());

    protected GenericResourceUpdaterMatcher() {
    }

    public static <R extends HasMetadata> ResourceUpdaterMatcher<R> updaterMatcherFor(Class<R> resourceType) {
        ResourceUpdaterMatcher<?> processor = processors.get(resourceType);
        return processor != null ? processor : INSTANCE;
    }

    @Override
    public R updateResource(R actual, R desired, Context<?> context) {
        R clonedActual = context.getControllerConfiguration().getConfigurationService().getResourceCloner().clone(actual);
        GenericResourceUpdaterMatcher.updateLabelsAndAnnotation(clonedActual, desired);
        this.updateClonedActual(clonedActual, desired);
        return clonedActual;
    }

    @Override
    public boolean matches(R actual, R desired, Context<?> context) {
        return GenericKubernetesResourceMatcher.match(desired, actual, true, false, false, context).matched();
    }

    protected void updateClonedActual(R actual, R desired) {
        GenericResourceUpdaterMatcher.updateSpec(actual, desired);
    }

    public static <K extends HasMetadata> void updateSpec(K actual, K desired) {
        Object desiredSpec = ReconcilerUtils.getSpec(desired);
        ReconcilerUtils.setSpec(actual, desiredSpec);
    }

    public static <K extends HasMetadata> void updateLabelsAndAnnotation(K actual, K desired) {
        actual.getMetadata().getLabels().putAll(desired.getMetadata().getLabels());
        actual.getMetadata().getAnnotations().putAll(desired.getMetadata().getAnnotations());
    }
}

