/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.core.dependent;

import io.debezium.operator.api.model.DebeziumServer;
import io.debezium.operator.api.model.DebeziumServerSpec;
import io.debezium.operator.core.dependent.ServiceAccountDependent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServiceAccountDependentTest {
    private final String MANAGED_SA_NAME = "test-ds-sa";
    private final String NAMESPACE = "debezium";
    private Context<DebeziumServer> context;
    private DebeziumServer debeziumServer;

    @BeforeEach
    void before() {
        this.debeziumServer = (DebeziumServer)ReconcilerUtils.loadYaml(DebeziumServer.class, ServiceAccountDependentTest.class, (String)"/test-samples/ds-postgres-minimal.yml");
        ObjectMeta metadata = ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName("test-ds")).withNamespace("debezium")).build();
        this.debeziumServer.setMetadata(metadata);
    }

    @Test
    void shouldReturnServiceAccount() {
        String saName = "test-ds-service-account";
        ((DebeziumServerSpec)this.debeziumServer.getSpec()).getRuntime().setServiceAccount(saName);
        String sa = ServiceAccountDependent.serviceAccountNameFor((DebeziumServer)this.debeziumServer);
        Assertions.assertThat((String)sa).isEqualTo(saName);
    }

    @Test
    void shouldReturnManagedServiceAccount() {
        String sa = ServiceAccountDependent.serviceAccountNameFor((DebeziumServer)this.debeziumServer);
        Assertions.assertThat((String)sa).isEqualTo("test-ds-sa");
    }

    @Test
    void shouldReturnDesiredServiceAccount() {
        ServiceAccountDependent serviceAccountDependent = new ServiceAccountDependent();
        ServiceAccount serviceAccount = serviceAccountDependent.desired(this.debeziumServer, this.context);
        Assertions.assertThat((String)serviceAccount.getMetadata().getName()).isEqualTo("test-ds-sa");
        Assertions.assertThat((String)serviceAccount.getMetadata().getNamespace()).isEqualTo("debezium");
    }
}

