/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.core;

import io.debezium.operator.api.config.ConfigMapping;
import io.debezium.operator.api.model.DebeziumServer;
import io.debezium.operator.api.model.DebeziumServerSpec;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.quarkus.kubernetes.client.runtime.KubernetesClientUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class DebeziumServerReconcilerTest {
    public static final String dsName = "test-ds";
    KubernetesClient client = KubernetesClientUtils.createClient();
    DebeziumServer debeziumServer;

    @BeforeEach
    void before() {
        this.debeziumServer = (DebeziumServer)ReconcilerUtils.loadYaml(DebeziumServer.class, DebeziumServerReconcilerTest.class, (String)"/test-samples/ds-postgres-minimal.yml");
        ObjectMeta metadata = ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(dsName)).withNamespace(this.client.getNamespace())).build();
        this.debeziumServer.setMetadata(metadata);
    }

    @AfterEach
    void after() {
        this.client.resource((HasMetadata)this.debeziumServer).delete();
    }

    @Test
    void shouldReconcileDebeziumServer() {
        this.client.resource((HasMetadata)this.debeziumServer).create();
        Awaitility.await().ignoreException(NullPointerException.class).atMost(2L, TimeUnit.MINUTES).untilAsserted(() -> {
            ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.debeziumServer.getMetadata().getNamespace())).withName(this.debeziumServer.getMetadata().getName())).get();
            Assertions.assertThat((Object)configMap).isNotNull();
            ConfigMapping config = this.debeziumServer.asConfiguration();
            Assertions.assertThat((Map)configMap.getData()).containsEntry((Object)"application.properties", (Object)config.getAsString());
            Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(this.debeziumServer.getMetadata().getNamespace())).withName(this.debeziumServer.getMetadata().getName())).get();
            Assertions.assertThat((Object)deployment).isNotNull();
            Assertions.assertThat((String)deployment.getMetadata().getName()).isEqualTo(this.debeziumServer.getMetadata().getName());
            Assertions.assertThat((List)deployment.getMetadata().getOwnerReferences()).anyMatch(owner -> owner.getName().equals(this.debeziumServer.getMetadata().getName()) && owner.getKind().equals(this.debeziumServer.getKind()));
            Optional maybeContainer = deployment.getSpec().getTemplate().getSpec().getContainers().stream().findFirst();
            Assertions.assertThat(maybeContainer).isPresent();
            Container container = (Container)maybeContainer.get();
            Assertions.assertThat((String)container.getImage()).isEqualTo(((DebeziumServerSpec)this.debeziumServer.getSpec()).getImage());
            Assertions.assertThat((Object)container.getLivenessProbe()).isNotNull();
            Assertions.assertThat((Object)container.getReadinessProbe()).isNotNull();
            Assertions.assertThat((List)container.getVolumeMounts()).hasSize(2);
            Assertions.assertThat((List)container.getVolumeMounts()).anyMatch(mount -> mount.getName().equals("ds-config") && mount.getMountPath().equals("/debezium/conf/application.properties") && mount.getSubPath().equals("application.properties"));
            Assertions.assertThat((List)container.getVolumeMounts()).anyMatch(mount -> mount.getName().equals("ds-data") && mount.getMountPath().equals("/debezium/data"));
        });
    }
}

