/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.core.dependent.conditions;

import io.debezium.operator.api.model.DebeziumServer;
import io.debezium.operator.api.model.DebeziumServerSpec;
import io.debezium.operator.api.model.runtime.Runtime;
import io.debezium.operator.api.model.runtime.storage.DataStorage;
import io.debezium.operator.api.model.runtime.storage.StorageType;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;

public class PvcReady
implements Condition<Deployment, DebeziumServer> {
    public boolean isMet(DependentResource<Deployment, DebeziumServer> dependentResource, DebeziumServer primary, Context<DebeziumServer> context) {
        Runtime runtime = ((DebeziumServerSpec)primary.getSpec()).getRuntime();
        DataStorage dataStorage = runtime.getStorage().getData();
        if (dataStorage.getType() == StorageType.EPHEMERAL) {
            return true;
        }
        if (dataStorage.getClaimName() != null) {
            return true;
        }
        return context.getSecondaryResource(PersistentVolumeClaim.class).isPresent();
    }
}

