/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.source.storage.schema;

import io.debezium.operator.api.model.ConfigProperties;
import io.debezium.operator.api.model.source.storage.RedisStoreWaitConfig;
import io.debezium.operator.api.model.source.storage.RedisStoreWaitConfigBuilder;
import io.debezium.operator.api.model.source.storage.RedisStoreWaitConfigFluent;
import io.debezium.operator.api.model.source.storage.schema.RedisSchemaHistoryStore;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class RedisSchemaHistoryStoreFluent<A extends RedisSchemaHistoryStoreFluent<A>>
extends BaseFluent<A> {
    private String address;
    private String user;
    private String password;
    private boolean sslEnabled;
    private String key;
    private RedisStoreWaitConfigBuilder wait;
    private ConfigProperties config;

    public RedisSchemaHistoryStoreFluent() {
    }

    public RedisSchemaHistoryStoreFluent(RedisSchemaHistoryStore instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RedisSchemaHistoryStore instance) {
        RedisSchemaHistoryStore redisSchemaHistoryStore = instance = instance != null ? instance : new RedisSchemaHistoryStore();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withUser(instance.getUser());
            this.withPassword(instance.getPassword());
            this.withSslEnabled(instance.isSslEnabled());
            this.withKey(instance.getKey());
            this.withWait(instance.getWait());
            this.withConfig(instance.getConfig());
        }
    }

    public String getAddress() {
        return this.address;
    }

    public A withAddress(String address) {
        this.address = address;
        return (A)((Object)this);
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user = user;
        return (A)((Object)this);
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public String getPassword() {
        return this.password;
    }

    public A withPassword(String password) {
        this.password = password;
        return (A)((Object)this);
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public A withSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return (A)((Object)this);
    }

    public boolean hasSslEnabled() {
        return true;
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key = key;
        return (A)((Object)this);
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public RedisStoreWaitConfig buildWait() {
        return this.wait != null ? this.wait.build() : null;
    }

    public A withWait(RedisStoreWaitConfig wait) {
        this._visitables.remove((Object)"wait");
        if (wait != null) {
            this.wait = new RedisStoreWaitConfigBuilder(wait);
            this._visitables.get((Object)"wait").add(this.wait);
        } else {
            this.wait = null;
            this._visitables.get((Object)"wait").remove((Object)this.wait);
        }
        return (A)((Object)this);
    }

    public boolean hasWait() {
        return this.wait != null;
    }

    public WaitNested<A> withNewWait() {
        return new WaitNested(null);
    }

    public WaitNested<A> withNewWaitLike(RedisStoreWaitConfig item) {
        return new WaitNested(item);
    }

    public WaitNested<A> editWait() {
        return this.withNewWaitLike(Optional.ofNullable(this.buildWait()).orElse(null));
    }

    public WaitNested<A> editOrNewWait() {
        return this.withNewWaitLike(Optional.ofNullable(this.buildWait()).orElse(new RedisStoreWaitConfigBuilder().build()));
    }

    public WaitNested<A> editOrNewWaitLike(RedisStoreWaitConfig item) {
        return this.withNewWaitLike(Optional.ofNullable(this.buildWait()).orElse(item));
    }

    public ConfigProperties getConfig() {
        return this.config;
    }

    public A withConfig(ConfigProperties config) {
        this.config = config;
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RedisSchemaHistoryStoreFluent that = (RedisSchemaHistoryStoreFluent)((Object)o);
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (this.sslEnabled != that.sslEnabled) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals((Object)this.wait, (Object)that.wait)) {
            return false;
        }
        return Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.user, this.password, this.sslEnabled, this.key, this.wait, this.config, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password + ",");
        }
        sb.append("sslEnabled:");
        sb.append(this.sslEnabled + ",");
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key + ",");
        }
        if (this.wait != null) {
            sb.append("wait:");
            sb.append(this.wait + ",");
        }
        if (this.config != null) {
            sb.append("config:");
            sb.append(this.config);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSslEnabled() {
        return this.withSslEnabled(true);
    }

    public class WaitNested<N>
    extends RedisStoreWaitConfigFluent<WaitNested<N>>
    implements Nested<N> {
        RedisStoreWaitConfigBuilder builder;

        WaitNested(RedisStoreWaitConfig item) {
            this.builder = new RedisStoreWaitConfigBuilder(this, item);
        }

        public N and() {
            return (N)RedisSchemaHistoryStoreFluent.this.withWait(this.builder.build());
        }

        public N endWait() {
            return this.and();
        }
    }
}

