package io.debezium.operator.api.model.source.storage.offset;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FileOffsetStoreBuilder extends FileOffsetStoreFluent<FileOffsetStoreBuilder> implements VisitableBuilder<FileOffsetStore,FileOffsetStoreBuilder>{
  public FileOffsetStoreBuilder() {
    this(new FileOffsetStore());
  }
  
  public FileOffsetStoreBuilder(FileOffsetStoreFluent<?> fluent) {
    this(fluent, new FileOffsetStore());
  }
  
  public FileOffsetStoreBuilder(FileOffsetStoreFluent<?> fluent,FileOffsetStore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FileOffsetStoreBuilder(FileOffsetStore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FileOffsetStoreFluent<?> fluent;
  
  public FileOffsetStore build() {
    FileOffsetStore buildable = new FileOffsetStore();
    buildable.setFileName(fluent.getFileName());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}