package io.debezium.operator.api.model.source.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CustomStoreBuilder extends CustomStoreFluent<CustomStoreBuilder> implements VisitableBuilder<CustomStore,CustomStoreBuilder>{
  public CustomStoreBuilder() {
    this(new CustomStore());
  }
  
  public CustomStoreBuilder(CustomStoreFluent<?> fluent) {
    this(fluent, new CustomStore());
  }
  
  public CustomStoreBuilder(CustomStoreFluent<?> fluent,CustomStore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CustomStoreBuilder(CustomStore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CustomStoreFluent<?> fluent;
  
  public CustomStore build() {
    CustomStore buildable = new CustomStore();
    buildable.setType(fluent.getType());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}