package io.debezium.operator.api.model.runtime;

import java.lang.SuppressWarnings;
import io.debezium.operator.api.model.runtime.storage.RuntimeStorage;
import io.debezium.operator.api.model.runtime.templates.TemplatesFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.debezium.operator.api.model.runtime.jmx.JmxConfigBuilder;
import io.debezium.operator.api.model.runtime.jmx.JmxConfigFluent;
import io.debezium.operator.api.model.runtime.templates.Templates;
import java.lang.String;
import io.debezium.operator.api.model.runtime.jmx.JmxConfig;
import io.debezium.operator.api.model.runtime.metrics.MetricsBuilder;
import io.debezium.operator.api.model.runtime.templates.TemplatesBuilder;
import io.debezium.operator.api.model.runtime.metrics.Metrics;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.debezium.operator.api.model.runtime.metrics.MetricsFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RuntimeFluent<A extends RuntimeFluent<A>> extends BaseFluent<A>{
  public RuntimeFluent() {
  }
  
  public RuntimeFluent(Runtime instance) {
    this.copyInstance(instance);
  }
  private RuntimeStorage storage;
  private RuntimeEnvironment environment;
  private JmxConfigBuilder jmx;
  private TemplatesBuilder templates;
  private String serviceAccount;
  private MetricsBuilder metrics;
  
  protected void copyInstance(Runtime instance) {
    instance = (instance != null ? instance : new Runtime());
    if (instance != null) {
          this.withStorage(instance.getStorage());
          this.withEnvironment(instance.getEnvironment());
          this.withJmx(instance.getJmx());
          this.withTemplates(instance.getTemplates());
          this.withServiceAccount(instance.getServiceAccount());
          this.withMetrics(instance.getMetrics());
        }
  }
  
  public RuntimeStorage getStorage() {
    return this.storage;
  }
  
  public A withStorage(RuntimeStorage storage) {
    this.storage = storage;
    return (A) this;
  }
  
  public boolean hasStorage() {
    return this.storage != null;
  }
  
  public RuntimeEnvironment getEnvironment() {
    return this.environment;
  }
  
  public A withEnvironment(RuntimeEnvironment environment) {
    this.environment = environment;
    return (A) this;
  }
  
  public boolean hasEnvironment() {
    return this.environment != null;
  }
  
  public JmxConfig buildJmx() {
    return this.jmx != null ? this.jmx.build() : null;
  }
  
  public A withJmx(JmxConfig jmx) {
    this._visitables.remove("jmx");
    if (jmx != null) {
        this.jmx = new JmxConfigBuilder(jmx);
        this._visitables.get("jmx").add(this.jmx);
    } else {
        this.jmx = null;
        this._visitables.get("jmx").remove(this.jmx);
    }
    return (A) this;
  }
  
  public boolean hasJmx() {
    return this.jmx != null;
  }
  
  public JmxNested<A> withNewJmx() {
    return new JmxNested(null);
  }
  
  public JmxNested<A> withNewJmxLike(JmxConfig item) {
    return new JmxNested(item);
  }
  
  public JmxNested<A> editJmx() {
    return withNewJmxLike(java.util.Optional.ofNullable(buildJmx()).orElse(null));
  }
  
  public JmxNested<A> editOrNewJmx() {
    return withNewJmxLike(java.util.Optional.ofNullable(buildJmx()).orElse(new JmxConfigBuilder().build()));
  }
  
  public JmxNested<A> editOrNewJmxLike(JmxConfig item) {
    return withNewJmxLike(java.util.Optional.ofNullable(buildJmx()).orElse(item));
  }
  
  public Templates buildTemplates() {
    return this.templates != null ? this.templates.build() : null;
  }
  
  public A withTemplates(Templates templates) {
    this._visitables.remove("templates");
    if (templates != null) {
        this.templates = new TemplatesBuilder(templates);
        this._visitables.get("templates").add(this.templates);
    } else {
        this.templates = null;
        this._visitables.get("templates").remove(this.templates);
    }
    return (A) this;
  }
  
  public boolean hasTemplates() {
    return this.templates != null;
  }
  
  public TemplatesNested<A> withNewTemplates() {
    return new TemplatesNested(null);
  }
  
  public TemplatesNested<A> withNewTemplatesLike(Templates item) {
    return new TemplatesNested(item);
  }
  
  public TemplatesNested<A> editTemplates() {
    return withNewTemplatesLike(java.util.Optional.ofNullable(buildTemplates()).orElse(null));
  }
  
  public TemplatesNested<A> editOrNewTemplates() {
    return withNewTemplatesLike(java.util.Optional.ofNullable(buildTemplates()).orElse(new TemplatesBuilder().build()));
  }
  
  public TemplatesNested<A> editOrNewTemplatesLike(Templates item) {
    return withNewTemplatesLike(java.util.Optional.ofNullable(buildTemplates()).orElse(item));
  }
  
  public String getServiceAccount() {
    return this.serviceAccount;
  }
  
  public A withServiceAccount(String serviceAccount) {
    this.serviceAccount = serviceAccount;
    return (A) this;
  }
  
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  public Metrics buildMetrics() {
    return this.metrics != null ? this.metrics.build() : null;
  }
  
  public A withMetrics(Metrics metrics) {
    this._visitables.remove("metrics");
    if (metrics != null) {
        this.metrics = new MetricsBuilder(metrics);
        this._visitables.get("metrics").add(this.metrics);
    } else {
        this.metrics = null;
        this._visitables.get("metrics").remove(this.metrics);
    }
    return (A) this;
  }
  
  public boolean hasMetrics() {
    return this.metrics != null;
  }
  
  public MetricsNested<A> withNewMetrics() {
    return new MetricsNested(null);
  }
  
  public MetricsNested<A> withNewMetricsLike(Metrics item) {
    return new MetricsNested(item);
  }
  
  public MetricsNested<A> editMetrics() {
    return withNewMetricsLike(java.util.Optional.ofNullable(buildMetrics()).orElse(null));
  }
  
  public MetricsNested<A> editOrNewMetrics() {
    return withNewMetricsLike(java.util.Optional.ofNullable(buildMetrics()).orElse(new MetricsBuilder().build()));
  }
  
  public MetricsNested<A> editOrNewMetricsLike(Metrics item) {
    return withNewMetricsLike(java.util.Optional.ofNullable(buildMetrics()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RuntimeFluent that = (RuntimeFluent) o;
    if (!java.util.Objects.equals(storage, that.storage)) return false;
    if (!java.util.Objects.equals(environment, that.environment)) return false;
    if (!java.util.Objects.equals(jmx, that.jmx)) return false;
    if (!java.util.Objects.equals(templates, that.templates)) return false;
    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;
    if (!java.util.Objects.equals(metrics, that.metrics)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(storage,  environment,  jmx,  templates,  serviceAccount,  metrics,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (environment != null) { sb.append("environment:"); sb.append(environment + ","); }
    if (jmx != null) { sb.append("jmx:"); sb.append(jmx + ","); }
    if (templates != null) { sb.append("templates:"); sb.append(templates + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (metrics != null) { sb.append("metrics:"); sb.append(metrics); }
    sb.append("}");
    return sb.toString();
  }
  public class JmxNested<N> extends JmxConfigFluent<JmxNested<N>> implements Nested<N>{
    JmxNested(JmxConfig item) {
      this.builder = new JmxConfigBuilder(this, item);
    }
    JmxConfigBuilder builder;
    
    public N and() {
      return (N) RuntimeFluent.this.withJmx(builder.build());
    }
    
    public N endJmx() {
      return and();
    }
    
  
  }
  public class TemplatesNested<N> extends TemplatesFluent<TemplatesNested<N>> implements Nested<N>{
    TemplatesNested(Templates item) {
      this.builder = new TemplatesBuilder(this, item);
    }
    TemplatesBuilder builder;
    
    public N and() {
      return (N) RuntimeFluent.this.withTemplates(builder.build());
    }
    
    public N endTemplates() {
      return and();
    }
    
  
  }
  public class MetricsNested<N> extends MetricsFluent<MetricsNested<N>> implements Nested<N>{
    MetricsNested(Metrics item) {
      this.builder = new MetricsBuilder(this, item);
    }
    MetricsBuilder builder;
    
    public N and() {
      return (N) RuntimeFluent.this.withMetrics(builder.build());
    }
    
    public N endMetrics() {
      return and();
    }
    
  
  }

}