package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DebeziumServerBuilder extends DebeziumServerFluent<DebeziumServerBuilder> implements VisitableBuilder<DebeziumServer,DebeziumServerBuilder>{
  public DebeziumServerBuilder() {
    this(new DebeziumServer());
  }
  
  public DebeziumServerBuilder(DebeziumServerFluent<?> fluent) {
    this(fluent, new DebeziumServer());
  }
  
  public DebeziumServerBuilder(DebeziumServerFluent<?> fluent,DebeziumServer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DebeziumServerBuilder(DebeziumServer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DebeziumServerFluent<?> fluent;
  
  public DebeziumServer build() {
    DebeziumServer buildable = new DebeziumServer();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setSpec(fluent.buildSpec());
    buildable.setStatus(fluent.buildStatus());
    buildable.setKind(fluent.getKind());
    buildable.setApiVersion(fluent.getApiVersion());
    return buildable;
  }
  

}