/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.source.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.debezium.operator.api.config.ConfigMappable;
import io.debezium.operator.api.config.ConfigMapping;

public class RedisStoreWaitConfig
implements ConfigMappable {
    @JsonPropertyDescription(value="In case of Redis with replica, this allows to verify that the data has been written to replica")
    @JsonProperty(defaultValue="false")
    private boolean enabled = false;
    @JsonPropertyDescription(value="Timeout in ms when waiting for replica")
    @JsonProperty(defaultValue="1000")
    private long timeoutMs = 1000L;
    @JsonPropertyDescription(value="Enables retry on wait for replica")
    @JsonProperty(defaultValue="false")
    private boolean retry = false;
    @JsonPropertyDescription(value="Delay of retry on wait")
    @JsonProperty(defaultValue="1000")
    private long retryDelayMs = 1000L;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setTimeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public long getRetryDelayMs() {
        return this.retryDelayMs;
    }

    public void setRetryDelayMs(long retryDelayMs) {
        this.retryDelayMs = retryDelayMs;
    }

    @Override
    public ConfigMapping asConfiguration() {
        return ConfigMapping.empty().put("enabled", this.enabled).put("timeout.ms", this.timeoutMs).put("retry.enabled", this.retry).put("retry.delay.ms", this.retryDelayMs);
    }
}

